# Code for the paper "Residual deep Gaussian processes on manifolds". 

## Overview
This repository contains three experiment directories,
- __synthetic_uci_wind-original__, which contains original files which can be ran to generate the data used for Sections 4.1, 4.3, and 4.4 of the manuscript. 
Each of these files contains all the code needed to run it; thus, they may not be easy to read. Furthermore, there are some differences in style between the files for individual experiments. Nevertheless, they are easily ran from the command line and reproduce the results in the paper exactly. We have provided a refactored, much cleaner implementation in the synthetic_uci_wind directory. This code also reproduces the results in the paper, up to differences caused by to randomness in sampling.

- __synthetic_uci_wind__, which is a refactored and unified in style version of synthetic_uci_wind-original. The minute differences in the results from the paper arise from randomness in sampling, which is different due to an optimised way of handling and representing gaussian distributions.

- __bayesian_optimisation__, which contains original files that were used to generate the data used for Section 4.2 of the manuscript. This folder is in considerably different style to the other files, as it is embedded in the gpytorch framework, from which we are moving away. It requires far more dependencies than the other code, but it can be ran easily. 

one data folder,
- __data__, where the datasets used for the UCI and wind interpolation experiments are stored. It also contains the files which can be used to download this data. 

and one dedicated plotting folder
- __plots__, where, by running each notebook, one can produce the files which were used for Blender renders in Figures 1, 2, 4, 5. 


### Detailed instructions 
#### `synthetic_uci_wind`
Each experiment in this folder has three corresponding files: `run_{experiment_name}.py`, `{experiment_name}_commands.ipynb`, and `plot_{experiment_name}.ipynb`. To run an experiment, you should:
1. Run the code in `{experiment_name}_commands.ipynb` to generate an executable files for running the chosen experiment for a desired set of parameters.
2. Execute the produced `run_{experiment_name}.sh` to run the experiment and save its result.
To visualise the results as it is done in the paper, one can execute the code `plot_{experiment_name}.ipynb`.
<br>
This `synthetic_uci_wind` directory also contains refactored code for the models used in these experiments. These are:
- `kernels.py`: all kernel objects
- `models.py`: all models objects, including priors, variational posteriors, and deep models 
- `spherical_harmonics.py`: spherical harmonics and vector spherical harmonics (called there spherical harmonic fields)
- `utils.py`: utility functions

#### `synthetic_uci_wind-original`
This folder has the same structure as __`synthetic_uci_wind`__, except that the code needed for experiment execution is stored in the `{experiment_name}_run.py` files and is not refactored.

#### `bayesian_optimisation`
To reproduce the experiments, one should first run the following commands from the `notebooks/bo_experiment` directory:
`python create_experiments_tree.py --config_path ../../experiment_tree_configs/bo/ackley-shallow.json`<br>
`python create_experiments_tree.py --config_path ../../experiment_tree_configs/bo/ackley-deep.json`<br>
`python create_experiments_tree.py --config_path ../../experiment_tree_configs/bo/irregular-shallow.json`<br>
`python create_experiments_tree.py --config_path ../../experiment_tree_configs/bo/irregular-deep.json`<br>
This will generate an `experiments` directory with a tree of experiment subdirectories within it. Each experiment subdirectory contains its own `config.json` file, which is utilised by the `run.py` file to run an experiment with the desired settings.  <br>

After, this has been completed, use should execute `run.py` by running the command `python run.py ../../experiments/bo/` from the same directory.
This will begin to execute all experiments in the `experiments/bo/` folder one by one, and the results will be saved automatically to their corresponding locations in the experiment tree. 

Sometimes experiment execution might fail. Unfortunately, according to our experience, this is hardware-, and especially memory-, dependent: on a computing cluster we experienced a much lower crash rate than on a personal laptop. Nevertheless, typically this can be resolved simply by retrying the experiment or switching the seed. 

#### data
The key file in this directory is `download_uci_data.sh`. This file should be executed to download the Yacht, Concrete, Energy, Kin8mn, and Power UCI datasets.

The ERA5 dataset should be downloaded manually, moved to the data folder, and renamed to `era5.nc`. 
To download the data, please visit https://cds.climate.copernicus.eu/datasets/reanalysis-era5-pressure-levels-monthly-means?tab=download and select the following options in the data request form
- Product type: Reanalysis
- Variable: U-component of wind, V-component of wind
- Pressure level: 500 hPa, 800 hPa, 1000 hPa
- Year: 2010
- Month: all available
- Time: 00:00
- Format: NetCDF.


### Requirements 

#### Synthetic, Wind, and UCI experiments 
First, please create a fresh Python 3.10.14 virtual environment (e.g. using conda or venv).
Then, please run the following command to install the necessary dependencies:
`pip install jax==0.4.30 gpjax matplotlib plotly numpy==1.26.4 pandas xlrd netCDF4 openpyxl skyfield cdsapi seaborn cartopy`


#### Bayesian optimisation experiments
First, please create a fresh Python 3.10.14 virtual environment (e.g. using conda or venv).
Then, while in the bayesian_optimisation directory, please run the following commands to install the necessary dependencies:
1. `pip install ./`
2. `cd required_packages`
3. `pip install GeometricKernels-torch-vectorized/`
4. `pip install SphericalHarmonics-MDGP/`
5. `pip install cclust_package-MDGP/`
