import numpy as np


def generate_qv_data(rawdata):
    n_data, n_state = np.shape(rawdata)
    n_state -= 1

    #curstate : 1~N-1
    curstate = rawdata[0:n_data-1,]
    #nextstate : 2 ~ N
    nextstate = rawdata[1:n_data,]

    term_cur = np.where(curstate[:,n_state]==1)

    curstate_edit = np.delete(curstate, term_cur, axis=0)
    nextstate_edit = np.delete(nextstate, term_cur, axis=0)

    return curstate_edit, nextstate_edit

def sample_data(dataset, batchsize):
    n_data, n_state = np.shape(dataset)
    getindex = np.random.permutation(n_data)
    dataindex = getindex[0:batchsize]
    return dataset[dataindex,0:n_state-1]

def sample_data2(curstate, nextstate, batchsize):
    n_data, n_state = np.shape(curstate)
    getindex = np.random.permutation(n_data)
    dataindex = getindex[0:batchsize]
    return curstate[dataindex, 0:n_state - 1], nextstate[dataindex, 0:n_state - 1]