import numpy as np
import sys
import math
import copy
from collections import defaultdict
from functions import *
import bisect


def original_greedy(g, dataset, k):
	#
	# This is the greedy algorithm for a single function g.
	#
	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	for i in range(k):
		max_margin = -1 * sys.maxsize
		best_element = 1
		best_auxiliary = set()
		for e in dataset['elements']:
			gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
			margin = gain_g 
			if margin > max_margin:
				max_margin = margin
				best_element = e
		if max_margin > 0:
			current_val, auxiliary = g.add_one_element(best_element, S, current_val, auxiliary)
			S.append(best_element)
	return S


def lazy_greedy(g, dataset, k):
	#
	# This is the greedy algorithm for a single function g.
	#
	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	gains = [(g.evaluate([e])[0], e, 0) for e in dataset['elements']]
	gains.sort()
	for i in range(k):
		flag = True
		while flag:
			candidate = gains.pop()
			e = candidate[1]
			if candidate[2] != i:
				gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
				bisect.insort(gains, (gain_g, e, i))
			else:
				current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
				S.append(e)
				flag = False
	return S


def fast_threshold_greedy_optimized(g, dataset, k, epsilon,  alpha = 1, ell = dict()):
	gamma = etimating_opt(g, dataset, k, ell)
	exp = math.exp(1)
	tau = 8 * alpha * gamma
	auxiliary = set()
	current_val = 0
	S = []
	cost_S = 0
	auxiliary = set()
	margin_cost = dict()
	elements = [e for e in dataset['elements']]
	elements_set = set(elements)
	while tau > ((1 - epsilon) * gamma) / exp and cost_S <= 1.0:
		# print(gamma, tau)
		for e in elements:
			if len(ell) == 0:
					cost = 1.0 / k
			else:
				cost = ell[e]
			if cost_S + cost <= 1:
				if e not in margin_cost or margin_cost[e] >= cost * tau:
					gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
					margin = gain_g
					margin_cost[e] = margin
					if margin >= cost * tau:
						current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
						S.append(e)
						if len(ell) == 0:
							cost_S += 1.0 / k
						else:
							cost_S += ell[e]
		tau = (1 - epsilon) * tau
		gains = []
		for e in margin_cost:
			gains.append((e, margin_cost[e]))
		gains.sort(key = lambda x: - x[1] )
		elements = []
		for (e, v) in gains:
			if e not in S:
				elements.append(e)
		current_elements = set(elements)
		for e in elements_set:
			if e not in current_elements:
				elements.append(e)
	return S



def stochastic_greedy(g, dataset, k, epsilon):
	n = dataset['nb_elements']
	r = - np.log(epsilon) * n / k
	r = min(max(int(r), 1), n)
	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	for i in range(k):
		max_margin = -1 * sys.maxsize
		best_element = 1
		best_auxiliary = set()
		candidate_elements = list(set(dataset['elements']) - set(S))
		sampled_elements = random.sample(candidate_elements, min(r, len(candidate_elements)))
		# print(n, k, r)
		for e in sampled_elements:
			gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
			margin = gain_g 
			if margin > max_margin:
				max_margin = margin
				best_element = e
		if max_margin > 0:
			current_val, auxiliary = g.add_one_element(best_element, S, current_val, auxiliary)
			S.append(best_element)
	return S

def stochastic_greedy_optimized(g, dataset, k, epsilon):
	n = dataset['nb_elements']
	r = - np.log(epsilon) * n / k
	r = min(max(int(r), 1), n)

	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	gains = []
	gains_set = set()
	for i in range(k):
		max_margin = -1 * sys.maxsize
		best_element = 1
		best_auxiliary = set()
		candidate_elements = list(set(dataset['elements']) - set(S))
		sampled_elements = random.sample(candidate_elements, min(r, len(candidate_elements)))
		sampled_elements_set = set(sampled_elements)
		checked_sampled_elements_set = set()
		# print(n, k, r)
		for e in sampled_elements:
			if e not in gains_set:
				gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
				bisect.insort(gains, (gain_g, e, i))
				gains_set.add(e)
		flag = True
		not_sampled_elements = []
		while flag:
			candidate = gains.pop()
			e = candidate[1]
			if e in sampled_elements_set:
				if candidate[2] != i:
					gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
					bisect.insort(gains, (gain_g, e, i))
				else:
					current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
					S.append(e)
					flag = False
			else:
				not_sampled_elements.append(candidate)
		for candidate in not_sampled_elements:
			bisect.insort(gains, candidate)
	return S


def marginal_ratio_thresholding(g, dataset, k, alpha, gamma, ell = dict()):
	random.shuffle(dataset['elements'])
	S = []
	auxiliary = set()
	current_val = 0
	cost_S = 0
	for e in dataset['elements']:
		if len(ell) == 0:
			cost = 1.0 / k
		else:
			cost = ell[e]
		if cost_S + cost <= 1.0:
			gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
			margin = gain_g
			if margin / cost >= ((alpha * gamma - current_val) / (1 - cost_S)):
				current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
				S.append(e)
	return S

def best_singelton(g, dataset, k, margin_dict, ell = dict()):
	final_S = []
	final_val = -1
	for e in dataset['elements']:
		if len(ell) == 0 or ell[e] <= 1:
			current_val = g.evaluate(e)[0]
			if current_val > final_val:
				final_S = [e]
				final_val = current_val
	return final_S

def get_K(dataset, ell):
	min_cost = 1
	for e in dataset['elements']:
		if ell[e] < min_cost:
			min_cost = ell[e]
	return math.ceil(1 / min_cost)

def dynamic_MRT(g, dataset, k, epsilon,  alpha = 1, ell = dict()):
	if k != 0 or len(ell) == 0:
		K = k
	else:
		K = get_K(dataset, ell)
	singelton = best_singelton(g, dataset, k, ell)
	m = g.evaluate(singelton)[0]
	thresholds_sets = dict()
	threshold = 1
	i = 0 
	while threshold <= K * m:
		if threshold >= m:
			thresholds_sets[threshold] = []
		i+=1
		threshold *= (1 + epsilon)
	
	for threshold in thresholds_sets:
		current_val, auxiliary = g.evaluate(thresholds_sets[threshold])
		cost_S_t = 0
		for e in thresholds_sets[threshold]:
			cost_S_t += ell[e]

		for e in dataset['elements']:
			marginal_gain = g.marginal_gain(e, thresholds_sets[threshold], current_val, auxiliary)[0]
			c_e = ell[e]
			if c_e + cost_S_t <= 1:
				if (marginal_gain / c_e) >= (((alpha * threshold) - current_val) / (1 - cost_S_t)):
					thresholds_sets[threshold].append(e)
					current_val, auxiliary = g.evaluate(thresholds_sets[threshold])
					cost_S_t = 0
					for e in thresholds_sets[threshold]:
						cost_S_t += ell[e]
	final_val = m
	final_soluton = singelton
	for threshold in thresholds_sets:
		current_val = g.evaluate(thresholds_sets[threshold])[0]
		if current_val > final_val:
			final_val = current_val
			final_soluton = thresholds_sets[threshold]
	return final_soluton


def best_singelton_optimized(g, dataset, k, margin_dict, ell = dict()):
	final_S = []
	final_val = -1
	for e in dataset['elements']:
		if len(ell) == 0 or ell[e] <= 1:
			current_val = g.evaluate(e)[0]
			margin_dict[e] = current_val
			if current_val > final_val:
				final_S = [e]
				final_val = current_val
	return final_S


def etimating_opt(g, dataset, k, ell = dict()):
	S = []
	auxiliary = set()
	current_val = 0
	for e in dataset['elements']:
		gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
		margin = gain_g
		if len(ell) == 0:
			cost = 1.0 / k
		else:
			cost = ell[e]
		if margin >= current_val * cost:
			current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
			S.append(e)
	return current_val / 4

def fast_threshold_greedy(g, dataset, k, epsilon,  alpha = 1, ell = dict()):
	gamma = etimating_opt(g, dataset, k, ell)
	exp = math.exp(1)
	tau = 8 * alpha * gamma
	auxiliary = set()
	current_val = 0
	S = []
	cost_S = 0
	auxiliary = set()
	while tau > ((1 - epsilon) * gamma) / exp and cost_S <= 1.0:
		# print(gamma, tau)
		for e in dataset['elements']:
			if len(ell) == 0:
					cost = 1.0 / k
			else:
				cost = ell[e]
			if cost_S + cost <= 1:
				gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
				margin = gain_g
				if margin >= cost * tau:
					current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)

					S.append(e)
					if len(ell) == 0:
						cost_S += 1.0 / k
					else:
						cost_S += ell[e]

		tau = (1 - epsilon) * tau
	return S

def density_greedy(g, dataset, ell):
	#
	# Density Greedy, starts with an empty set S and keeps adding elements greedily 
	# by the ratio of their marginal gain to the total knapsack cost of each element 
	# while the k-system and l-knapsack constraints are satisfied. 
	#
	auxiliary = set()
	current_val = 0
	S = []
	cost_S = 0
	auxiliary = None
	flag = True
	while flag:
		flag = False
		max_margin = -1 * sys.maxsize
		best_element = -1
		best_auxiliary = set()
		for e in dataset['elements']:
			coset_e = ell[e] + 0.000000001
			if cost_S + coset_e <= 1:
				gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
				margin = gain_g / coset_e
				if margin > max_margin:
					max_margin = margin
					best_element = e
		if max_margin > 0:
			current_val, auxiliary = g.add_one_element(best_element, S, current_val, auxiliary)
			S.append(best_element)
			cost_S += ell[best_element]
			flag = True
	return S

def density_greedy_optimized(g, dataset, ell):
	#
	# Density Greedy, starts with an empty set S and keeps adding elements greedily 
	# by the ratio of their marginal gain to the total knapsack cost of each element 
	# while the k-system and l-knapsack constraints are satisfied. 
	#
	auxiliary = set()
	current_val = 0
	S = []
	cost_S = 0
	auxiliary = None
	flag = True
	margin_dict = dict()
	while flag:
		flag = False
		max_margin = -1 * sys.maxsize
		best_element = -1
		best_auxiliary = set()
		for e in dataset['elements']:
			coset_e = ell[e] + 0.000000001
			if cost_S + coset_e <= 1:
				if e not in margin_dict or margin_dict[e] >= max_margin:
					gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
					margin = gain_g / coset_e
					margin_dict[e] = margin
					if margin > max_margin:
						max_margin = margin
						best_element = e
		if max_margin > 0:
			current_val, auxiliary = g.add_one_element(best_element, S, current_val, auxiliary)
			S.append(best_element)
			cost_S += ell[best_element]
			flag = True
	return S



def fast_threshold_greedy_post_processing(g, dataset, ell, epsilon):
	S = fast_threshold_greedy(g, dataset, 0, epsilon,  1 / epsilon, ell)
	log_epsilon = int(math.floor(math.log(1 / epsilon, 1 + epsilon)))
	final_S = S
	final_val = g.evaluate(S)[0]

	for i in range(log_epsilon):
		cost_epsilon = epsilon * (math.pow(1+epsilon, i))
		j = 0
		S_cost = 0
		S_i = []
		for e in S:
			if S_cost + ell[e] <= cost_epsilon:
				S_i.append(e)
				S_cost += ell[e]
		U_i = []
		for e in dataset['elements']:
			if e not in S_i:
				if ell[e] + S_cost <= 1:
					U_i.append(e)
		auxiliary = None
		current_val, auxiliary = g.evaluate(S_i)
		best_u = -1
		gain_u = 0
		for u in U_i:
			gain_g, auxiliary = g.marginal_gain(u, S_i, current_val, auxiliary)
			# margin_dict[u] = gain_g
			if gain_g > gain_u:
				gain_u = gain_g
				best_u = u
		if best_u != -1:
			S_i.append(best_u)

		current_val = g.evaluate(S_i)[0]
		if current_val > final_val:
			final_S = S_i
			final_val = current_val

	for e in dataset['elements']:
		current_val = g.evaluate(e)[0]
		if current_val > final_val:
			final_S = [e]
			final_val = current_val

	return final_S


def fast_threshold_greedy_post_processing_optimized(g, dataset, ell, epsilon):
	S = fast_threshold_greedy_optimized(g, dataset, 0, epsilon,  1 / epsilon, ell)
	log_epsilon = int(math.floor(math.log(1 / epsilon, 1 + epsilon)))
	final_S = S
	final_val = g.evaluate(S)[0]

	old_S_i = set()
	margin_dict = dict()
	for i in range(log_epsilon):
		cost_epsilon = epsilon * (math.pow(1+epsilon, i))
		j = 0
		S_cost = 0
		S_i = []
		for e in S:
			if S_cost + ell[e] <= cost_epsilon:
				S_i.append(e)
				S_cost += ell[e]
		U_i = []
		for e in dataset['elements']:
			if e not in S_i:
				if ell[e] + S_cost <= 1:
					U_i.append(e)
		if len(set(S_i) - old_S_i) != 0:
			old_S_i = set(S_i)
			auxiliary = None
			current_val, auxiliary = g.evaluate(S_i)
			best_u = -1
			gain_u = -1
			for u in U_i:
				if u not in margin_dict or margin_dict[u] > gain_u:
					gain_g, auxiliary = g.marginal_gain(u, S_i, current_val, auxiliary)
					margin_dict[u] = gain_g
					if gain_g > gain_u:
						gain_u = gain_g
						best_u = u
			if best_u != -1:
				S_i.append(best_u)

			current_val = g.evaluate(S_i)[0]
			if current_val > final_val:
				final_S = S_i
				final_val = current_val

		random.shuffle(dataset['elements'])
	for e in dataset['elements']:
		current_val = g.evaluate(e)[0]
		if current_val > final_val:
			final_S = [e]
			final_val = current_val

	return final_S



def quick_stream(g, dataset, k, epsilon, c = 1):
	l = int(math.ceil(math.log(1 / (4 * epsilon), 2)) + 3)
	S_size = 2 * c * l * (k + 1) * math.log(k,2)
	auxiliary = set()
	current_val = 0
	S = []
	for e in dataset['elements']:
		gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
		margin = gain_g
		if gain_g > current_val / k:
			current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
			S.append(e)
		if len(S) > S_size:
			S = S[-S_size:]
	
	if len(S) > k:
		S = S[-k:]
	return S


def boost_ratio(g, dataset, k, epsilon):
	x = 1
	alpha = 0.25
	streaming_solution = quick_stream(g, dataset, k, epsilon)
	gamma = g.evaluate(streaming_solution)[0]
	tau = gamma / (alpha * k)
	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	while tau >= (1 - epsilon) * gamma / (4 * k)  and len(S) < k:
		tau = (1 - epsilon) * tau
		for e in dataset['elements']:
			if len(S) < k:
				gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
				margin = gain_g
				if margin >= tau:
					current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
					S.append(e)
	return S


def quick_stream_optimized(g, dataset, k, epsilon, gain_dict, c = 1):
	l = int(math.ceil(math.log(1 / (4 * epsilon), 2)) + 3)
	S_size = 2 * c * l * (k + 1) * math.log(k,2)
	auxiliary = set()
	current_val = 0
	S = []
	for e in dataset['elements']:
		gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
		margin = gain_g
		gain_dict[e] = margin
		if gain_g > current_val / k:
			current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
			S.append(e)
		if len(S) > S_size:
			S = S[-S_size:]
	
	if len(S) > k:
		S = S[-k:]
	return S

def boost_ratio_optmized(g, dataset, k, epsilon):
	x = 1
	alpha = 0.25
	gain_dict = dict()
	streaming_solution = quick_stream(g, dataset, k, epsilon)
	gamma = g.evaluate(streaming_solution)[0]
	tau = gamma / (alpha * k)
	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	while tau >= (1 - epsilon) * gamma / (4 * k)  and len(S) < k:
		tau = (1 - epsilon) * tau
		for e in dataset['elements']:
			if len(S) < k:
				if e not in gain_dict or gain_dict[e] >= tau:
					gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
					margin = gain_g
					gain_dict[e] = gain_g
					if margin >= tau:
						current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
						S.append(e)
	return S



def greedy(g, ell, dataset, k):
	#
	# This implements the greedy algorithm for g - ell
	#
	auxiliary = set()
	current_val = 0
	S = []
	auxiliary = set()
	for i in range(k):
		max_margin = -1 * sys.maxsize
		best_element = 1
		best_auxiliary = set()
		for e in dataset['elements']:
			gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
			gain_ell = ell(dataset, e)
			margin = gain_g - gain_ell
			if margin > max_margin:
				max_margin = margin
				best_element = e
				#best_auxiliary = copy.copy(new_auxiliary)
		if max_margin > 0:
			current_val, auxiliary = g.add_one_element(best_element, S, current_val, auxiliary)
			S.append(best_element)
	return S




def streaming_given_threshold(g, ell, r, tau, dataset, k):
	#
	# This function implements the THRESHOLD-STREAMING algorithm.
	#
	alpha = (2 * r + 1 + math.sqrt(4 * (r**2) + 1)) / 2.0
	S = []
	auxiliary = set()
	current_val = 0
	for e in dataset['elements']:
		gain_g, new_auxiliary = g.marginal_gain(e, S, current_val, auxiliary)
		gain_ell = ell(dataset, e)
		margin = gain_g - alpha * gain_ell
		if margin >= tau:
			current_val, auxiliary = g.add_one_element(e, S, current_val, auxiliary)
			S.append(e)
		if len(S) == k:
			return S
	return S






def FANTOM(f,dataset,constraint,epsilon = 0.2):
	#
	# Implementation of the FANTOM algorithm from:
	# Algorihm 3 from
	# Baharan Mirzasoleiman, Ashwinkumar Badanidiyuru, and Amin Karbasi. 
	# Fast Constrained Submodular Maximization: Personalized Data Summarization. 
	# In ICML, pages 1358–1367, 2016.
	#
	n = len(dataset['elements'])
	vals_elements = [f.evaluate(e)[0] for e in dataset['elements']]
	M = max(vals_elements)
	U = []
	omgea = set([e for e in dataset['elements']])
	S = CandidateSol()
	p = constraint.nb_matroids
	ell = constraint.nb_knapsacks
	gamma = (2 * p * M) / ( (p+1) * (2 * p + 1))
	R = []
	val = 1
	while  val <= n:
		R.append(val * gamma)                                                                                         
		val *= (1 + epsilon)

	for rho in R:
		omega = set([e for e in dataset['elements']])
		sols = iterated_GDT(f,dataset,constraint,omega,rho)
		for sol in sols:
			U.append(sol)

	final_soluton = []
	final_val = -1 * sys.maxsize
	for sol in U:
		current_val, __ = f.evaluate(sol)
		if current_val > final_val:
			final_val = current_val
			final_soluton = copy.copy(sol)

	#print(final_val, final_soluton)

	return final_val,  final_soluton

def iterated_GDT(f, dataset,constraint,ground,rho):
	#
	# sub-routine for FFANTOM
	# Algorihm 2: IGDT - Iterated greedy with density threshold
	# Mirzasoleiman, B., Badanidiyuru, A., and Karbasi, A. 
	# Fast Constrained Submodular Maximization: Personalized Data Summarization. 
	# In ICML, pp. 1358–1367, 2016a.
	#
	S = CandidateSol()
	p = constraint.nb_matroids
	ell = constraint.nb_knapsacks
	S_i = []
	for i in range(p+1):
		S = GDT(f,dataset,constraint,ground,rho)
		S_i.append(copy.copy(S.S_list))
		ground = ground - S.S_set
	return S_i

def GDT(f, dataset, constraint, ground, rho):
	#
	# Algorihm 1: GDT - Greedy with density threshold
	# Mirzasoleiman, B., Badanidiyuru, A., and Karbasi, A. 
	# Fast Constrained Submodular Maximization: Personalized Data Summarization. 
	# greedy with density threshold
	# runs the greedy on the on the groundser
	# an element is added if its marginal gain is larger than a threshold
	#
	S = CandidateSol()
	current_val = None
	flag = True
	while flag:
		flag = False
		cand = -1
		cand_val = -1 * sys.maxsize
		for e in ground:
			if constraint.is_add_feasible(e, S.S_list):
				val, __ = f.marginal_gain(e, S.S_list, current_val, S.auxiliary)
				if  val / (sum(constraint.costs[e]) + 0.000001) >= rho:
					if val > cand_val:
						cand = e
						cand_val = val
						flag = True
		if cand != -1:
			S.add_elements(cand)
			current_val, S.auxiliary = f.evaluate(S.S_list)
	return S

def fast_algorithms(f,dataset,constraint, epsilon = 0.2):
	#
	# Algorithm 10 from the following paper:
	# Badanidiyuru, A. and Vondrák, J. 
	# Fast algorithms for maximizing submodular functions. 
	# In ACM-SIAM symposium on Discrete algorithms (SODA), pp. 1497–1514, 2014.
	#
	n = len(dataset['elements'])
	vals_elements = [f.evaluate(e)[0] for e in dataset['elements']]
	M = max(vals_elements)

	p = constraint.nb_matroids
	ell = constraint.nb_knapsacks

	threshold_guesses = []
	guess = M / (p + ell * 1.0)
	while  guess <= (2 * constraint.max_cardinality * M) / (p + ell * 1.0):
		threshold_guesses.append(guess)
		guess *= (1 + epsilon)

	T_sols = []
	T_prime_sols = []
	for rho in threshold_guesses:
		vals_elements = [f.evaluate(e)[0] for e in dataset['elements']]
		rho_vals = [vals_elements[i] for i in range(n) if  (sum(constraint.costs[i]) == 0 or (vals_elements[i] / sum(constraint.costs[i])) >= rho )]
		if len(rho_vals) > 0:
			M_rho = max(rho_vals)
			#print(rho, M_rho, len(rho_vals))
			tau = M_rho
			S = CandidateSol()
			current_val = None
			S_rho = set()
			violate_flag = False
			while tau >= (epsilon / n ) * M_rho and constraint.check_costs(S.S_list):
				for j in dataset['elements']:
					if all([c <= 1 for c in constraint.costs[j]]):
						margin_j, __ = f.marginal_gain(j, S.S_list, current_val, S.auxiliary)
						if margin_j >= tau and (sum(constraint.costs[j]) == 0 or margin_j / sum(constraint.costs[j]) >= rho) and constraint.is_psystem_add_feasible(j, S.S_list):
							S.add_elements(j)
							current_val, S.auxiliary = f.evaluate(S.S_list)
							violate_flag = False
							if not constraint.check_costs(S.S_list):
								S_rho = copy.copy(S.S_set)
								T_rho = copy.copy(S.S_set)
								T_rho.remove(j)
								T_prime_pho = {j}
								violate_flag = True
								break
						if violate_flag:
							break
				if violate_flag:
					break
				tau = tau / (1.0 + epsilon)
		if 'violate_flag' in locals():
			if not violate_flag:
				T_rho = copy.copy(S.S_set)
				T_prime_pho = []
		if 'T_rho' in locals():
			T_sols.append(copy.copy(T_rho))
		if 'T_prime_pho' in locals():
			if len(T_prime_pho) > 0:
				T_prime_sols.append(copy.copy(T_prime_pho))

	final_soluton = []
	final_val = -1 * sys.maxsize
	for sol in T_prime_sols:
		current_val, __ = f.evaluate(sol)
		if current_val > final_val:
			final_val = current_val
			final_soluton = copy.copy(sol)

	for sol in T_sols:
		current_val, __ = f.evaluate(sol)
		if current_val > final_val:
			final_val = current_val
			final_soluton = copy.copy(sol)
	#print(final_val, final_soluton)
	return final_val, final_soluton