# SQuant Framework

## Environment

```bash
conda create -n squant python==3.8
conda activate squant
conda install pytorch torchvision torchaudio cudatoolkit=11.1 -c pytorch -c nvidia
pip install pytorchcv==0.0.51
pip install ./squant-kernel
```

## ImageNet Path

Please set your dataset path using "--dataset_path /your/imagenet_path".

## Run SQuant

```bash
# Quantize resnet-18 in 4-bit with SQuant
python -u main.py --model resnet18 --mode squant -wb 4 -ab 4  -s 12

# Test all models in Table 1 of the submitted manuscript.
./run.sh

# Ablation study results in Table 2,3 of the submitted manuscript.
./run_ablation.sh
```



## Quantization Rules
1. The weight and activation should be quantized correctly when inference.
    - Weight is per-(output) channel quantization.
      - Affine quantzation, same as ZeroQ and GDFQ.
    - Activation (input) must be per-tensor quantization: all elements must have ONE quantization range (min/max).
      - The clip method is a BN-based method from DFQ with a wider clip range.
      - All models have the same sigma setting of the BN-based method under the same bit-width.
    - The first layer input does not need quantization. 
      - Same as other frameworks, such as ZeroQ and GDFQ.
    - The last layer input uses 8bit quantization. 
      - Lower bit-width than other frameworks, such as ZeroQ and GDFQ
      - Note that other frameworks didn't quantize the last layer.


2. The quantization procedure MUST not involve any real dataset information. (data-free)
    - Weight quantization should finish before the inference without training/validation dataset.
    - Activation can only quantize in inference runtime. However, its quantization range should be set before inference without a training/validation dataset.

3. Test all models
    - All models use the same hyperparameters under the same bit-width.
    - The results should fit the results (with $\pm 0.2$ error) presented in the manuscript.

3. Ablation study
    - Reproduce the same results as in the manuscript.
