import os


SUDOKU_ANSWERS = {
    'sd4x4-s-0-r'  : 288,
    'sd4x4-f-0-r'  : 288,
    'sd4x4-s-1-r'  : 72,
    'sd4x4-f-1-r'  : 72,
    'sd4x4-s-2-r'  : 12,
    'sd4x4-f-2-r'  : 12,
    'sd4x4-s-3-r'  : 3,
    'sd4x4-f-3-r'  : 3,
    'sd4x4-s-4-r'  : 1,
    'sd4x4-f-4-r'  : 1,
    'sd9x9-s-0-r'  : 6670903752021072936960,
    'sd9x9-f-0-r'  : 6670903752021072936960,
    'sd9x9-s-13-r' : None,
    'sd9x9-f-13-r' : None,
    'sd9x9-s-14-r' : None,
    'sd9x9-f-14-r' : None,
    'sd9x9-s-15-r' : 4503632,
    'sd9x9-f-15-r' : 4503632,
    'sd9x9-s-16-r' : 83525,
    'sd9x9-f-16-r' : 83525,
    'sd9x9-s-17-r' : 1,
    'sd9x9-f-17-r' : 1}



def check_answer(instance, answer):
    filename = os.path.basename(instance)
    task = filename.split('.')[0]
    correct_answer = SUDOKU_ANSWERS.get(task)

    if correct_answer is None:
        return "UNKNOWN"
    else:
        return correct_answer == int(answer)
