from src.templates import *

def create_end_to_end_prompt(instance, prompt_format):
    data = {}

    with open(instance, "r") as f:
        lines = f.readlines()
        # Remove comments from DIMACS to keep the prompt shorter.
        dimacs = [line for line in lines if not line.strip().startswith('c')]
        data["instance"] = ''.join(dimacs)

    if prompt_format == 'base':
        template = END_TO_END_PROMPT
    elif prompt_format == 'kc':
        template = KC_PROMPT
    elif prompt_format == 'sudoku_free':
        template = SUDOKU_FREE_PROMPT

    prompt = template.substitute(data)
    return prompt


def create_python_code_prompt(instance, dimacs):
    data = {}

    with open(instance, "r") as f:
        lines = f.readlines()
        # Remove comments from DIMACS to keep the prompt shorter.
        dimacs = [line for line in lines if not line.strip().startswith('c')]
        data["instance"] = ''.join(dimacs)

    if dimacs:
        template = DIMACS_PYTHON_PROMPT
    else:
        template = PYTHON_PROMPT

    prompt = template.substitute(data)
    return prompt
