from string import Template

DIMACS_PYTHON_PROMPT = Template("""
You are counting solutions for an instance of the Sudoku puzzle. The instance will be encoding in SAT using the DIMACS instance format. Given an instance, you must answer with a Python program that receives the instance via standard input and outputs the number of models for the formula. Write the Python code in-between the tags <code>...</code>. You should not import any module which is not natively available in Python 3.11."

A Sudoku puzzle consists of a 9x9 grid into which the digits 1, ..., 9 must be inserted, 9 instances of each digit, in such a way that no digit appears twice in any row, column or in any of the 9 sub-grids (each of size 3x3).

Here is a brief explanation of the DIMACS format:
- A line starting with character c is a comment. You may ignore it.
- Variables are consecutively numbered from 1 to n.
- The problem description is given by a unique line of the form p cnf NumVariables NumClauses that we expect to be the first line (except comments). More precisely, the line starts with character p (no other line may start with p), followed by the problem descriptor cnf, followed by number n of variables followed by number m of clauses each symbol is separated by space each time.
- The remaining lines indicate clauses consisting of decimal integers separated by space. Lines are terminated by character 0. The line "2 -1 3 0" indicates the clause "2 or not 1 or 3".

The instance:
$instance

""")
