#!/usr/bin/env bash

# Directory containing CNF files (default is current directory)
CNF_DIR="../benchmarks/sudoku"

# Path to solver executable (replace with your solver if different)
SOLVER="./compiler_static"

# Create output directory
OUT_DIR="../benchmarks/kc_2"
mkdir -p "$OUT_DIR"

# Loop over all .cnf files
for file in "$CNF_DIR"/*.cnf; do
    if [[ -f "$file" ]]; then
        filename=$(basename "$file" .cnf)
        echo "Solving $file..."
        "$SOLVER" "-i" "$file" "--dump-file=$OUT_DIR/$filename.out"
    fi
done

echo "All .cnf files processed. Results in $OUT_DIR/"
