from dataclasses import dataclass

BENCHMARKS = "benchmarks"

@dataclass
class DomainSuite:
    name: str
    domain: str

SUITES = {
    "blocksworld": DomainSuite(
        "blocksworld",
        f"{BENCHMARKS}/blocksworld/training/domain.pddl"
    ),
    "childsnack": DomainSuite(
        "childsnacks",
        f"{BENCHMARKS}/childsnack/training/domain.pddl"
    ),
    "ferry": DomainSuite(
        "ferry",
        f"{BENCHMARKS}/ferry/training/domain.pddl"
    ),
    "floortile": DomainSuite(
        "floortile",
        f"{BENCHMARKS}/floortile/training/domain.pddl"
    ),
    "miconic": DomainSuite(
        "miconic",
        f"{BENCHMARKS}/miconic/training/domain.pddl"
    ),
    "rovers": DomainSuite(
        "rovers",
        f"{BENCHMARKS}/rovers/training/domain.pddl"
    ),
     "satellite": DomainSuite(
        "satellite",
        f"{BENCHMARKS}/satellite/training/domain.pddl"
    ),
    "sokoban": DomainSuite(
        "sokoban",
        f"{BENCHMARKS}/sokoban/training/domain.pddl"
    ),
    "spanner": DomainSuite(
        "spanner",
        f"{BENCHMARKS}/spanner/training/domain.pddl"
    ),
    "transport": DomainSuite(
        "transport",
        f"{BENCHMARKS}/transport/training/domain.pddl"
    )
}
