from string import Template

PYTHON_PROMPT = Template("""
You are counting solutions for an instance of the Sudoku puzzle. The instance will be encoding in SAT using the c2d instance format. Given an instance, you must answer with a Python program that receives the instance via standard input and outputs the number of models for the formula. Write the Python code in-between the tags <code>...</code>.

A Sudoku puzzle consists of a 9x9 grid into which the digits 1, ..., 9 must be inserted, 9 instances of each digit, in such a way that no digit appears twice in any row, column or in any of the 9 sub-grids (each of size 3x3).

Here is a brief explanation of the c2d instance format:
First, a preamble line 'nnf v e n' where
- v is the number of nodes,
- e is the number of edges,
- n is the number of Boolean variables under consideration;

Then, a sequence of leaf-nodes (one per line), and-nodes and or-nodes, appearing according to the topological order (children must be described before their parents); note that every node is implicitly indexed by an integer from 0 to v-1, such that the induced order respects the order of declaration.

A leaf node is specified by an expression L [-]j, where j (resp. -j) denotes the positive (resp. negative) literal of the j th variable (with j in [1,...,n]). One can build Boolean constant nodes using special cases of and-nodes and or-nodes (defined below): A 0 stands for true, while O 0 0 stands for false.

An and-node is declared using a statement A c i1 ... ic where c is the number of children the and-node admits, and i1 ... ic are the indexes of these children. An or-node is declared using a statement O j c i1 ... ic where c i1 ... ic give the node children and j defines the variable on which the children conflicts if it is different from 0. Note that as we consider d-DNNF representations, the two following patterns are the only ones which are allowed:

- 0 j 2 i1 i2 for a decision node,
- O 0 0 for the false node.

The instance:
$instance

""")
