# Hybrid Kernel Stein Variational Gradient Descent (h-SVGD)

This repository contains code accompanying the paper <a href="https://openreview.net/forum?id=JZkbMSQDmD" target="_blank">Convergence Aspects of Hybrid Kernel SVGD</a> [1]. Much of the code in this repository is adapted from the <a href="https://github.com/DartML/Stein-Variational-Gradient-Descent" target="_blank">repository</a> that accompanies the <a href="https://proceedings.neurips.cc/paper_files/paper/2016/hash/b3ba8f1bee1238a2f37603d90b58898d-Abstract.html" target="_blank">Stein Variational Gradient Descent paper</a> (Liu & Wang) paper, which appeared in NeurIPS 2016. The sliced SVGD implementation is adapted from the <a href="https://github.com/WenboGong/Sliced_Kernelized_Stein_Discrepancy" target="_blank">repository</a> that accompanies the <a href="https://arxiv.org/abs/2006.16531" target="_blank">Sliced Kernelized Stein Discrepancy</a> (Gong et al.) paper, which appeared in ICLR 2021.

---

## Key details of repository structure

```
.
├── src/
│   ├── bnn_energy_dist_plot.py  # Code to plot the energy distances for the Bayesian neural network example
│   ├── bnn.py                   # Code specific to the Bayesian neural netowrk examples
│   └── kernels.py               # Auxiliary functions for computing kernels and gradients
│   └── mvn-mixture.py           # Code specific to the multivariate normal mixture example
│   └── nuts.py                  # Code specific to the No U-Turn Sampler
│   └── svgd.py                  # Classes for SVGD, h-SVGD and S-SVGD
├── data/                        # Datasets for the Bayesian neural network example
├── environment.yml              # Conda environment specification
└── bnn.sh                       # Helper script to execute the Bayesian neural network example
└── README.md                    # Project documentation
└── mvn-mixture.sh               # Helper script to execute the multivariate normal mixture example
```

---

## 🛠️ Requirements

- [Miniconda or Anaconda](https://docs.conda.io/en/latest/miniconda.html)

---

## 🧪 Setup Instructions

1. **Create the Conda environment**

   ```bash
   conda env create -f environment.yml
   ```

2. **Activate the environment**

   ```bash
   conda activate h-svgd-torch
   ```

---

## Example 1: Multivariate Normal Mixture

Simply run the helper script. The script contains arguments (e.g. step size, dimension range) which may be modified.

```bash
bash mvn-mixture.sh
```

This script will generate plots and save them in the `mvn` directory.

---

## Example 2: Bayesian Neural Network

All datasets processed in this example should be placed in the `data` directory in either `.csv` or `.arff` format. Ensure that the label being predicted is in the last column and that features are in the other columns. This repository does not contain datasets, but the datasets used can all be retrieved from the <a href="https://archive.ics.uci.edu/" target="_blank">UCI Machine Learning Repository</a> or the <a href="https://www.openml.org/" target="_blank">OpenML Data Repository</a>.

Once the datasets have been acquired, simply run the helper script. The script contains arguments (e.g. step size, dimension range) which may be modified.

```bash
bash bnn.sh
```

This script will store samples under the `bnn/samples/<algorithm>` directory where `algorithm` takes values `svgd`, `hsvgd`, `ssvgd` or `nuts`. It will also store an energy distance plot under the `bnn` directory, and statistics for all algorithms under `bnn/<dataset>.csv` for each dataset provided.