# RotoGrad: Gradient Homogenization for Multitask Learning

## Installation

You can install all RotoGrad's dependencies using the file `environment.yml` to create a conda environment:

```
conda env create -f environment.yml
conda activate rotograd
```

## Usage
All experiments details are described through yaml configuration files.
We have prepared configuration files to run the experiments. All of them can be found
in the `configs` folder. Results are stored in the `results` folder.

The program reads configuration files in a hierarchical way, meaning that the latter configuration files overwrites the previous.

 ### Loading checkpoints

We provide checkpoints for the MNIST/CIFAR10 experiments (only for some, due to size constraints in the zip file). These can be loaded and evaluated by simply running, for example:

```bash
python main.py -c=checkpoints/mnist/rotograd/args.yml | tail -n1
python main.py -c=checkpoints/mnist/imtl-g/args.yml | tail -n1
```

Results are shown in the standard output and saved in the same folder as the `args.yml` file.

### Training a model

It is also possible to train a model from scratch, included the illustrative examples.

```bash
# First regression experiment
python main.py -c=configs/experiments/regression1.yml -c=configs/methods/rotograd.yml

# Second regression experiment
python main.py -c=configs/experiments/regression2.yml -c=configs/methods/rotograd.yml

# Logistic regression experiment (appendix)
python main -c=configs/experiments/logistc_regression.yml -c=configs/methods/rotograd.yml

# MNIST
python main -c=configs/experiments/mnist.yml -c=configs/methods/vanilla.yml
python main -c=configs/experiments/mnist.yml -c=configs/methods/rotograd.yml
```

