import torch


def norm(tensor):
    return tensor.norm(p=2, dim=-1, keepdim=True)


def divide(numer, denom):
    """Numerically stable division"""
    epsilon = 1e-15
    return torch.sign(numer) * torch.sign(denom) * torch.exp(torch.log(numer.abs() + epsilon) - torch.log(denom.abs() + epsilon))


def unitary(tensor):
    return divide(tensor, norm(tensor) + 1e-15)


def projection(u, v):
    numer = torch.dot(u, v)
    denom = torch.dot(v, v)

    return numer / denom * v
