# Video Agent experiments

This repository contains all our experiments for VideoAgent on MetaWorld and iThor simulation benchmarks.


## Getting started

We recommend to create a new environment with pytorch installed using conda. 

```bash  
conda create -n videoagent_exp python=3.9
conda activate videoagent_exp
conda install pytorch=2.2.0 torchvision torchaudio pytorch-cuda=11.8 -c pytorch -c nvidia
```  

Next, clone the repository and install the requirements  

```bash
git clone #repo
cd videoagent_experiments
pip install -r requirements.txt
```

## Running the Experiments

First, cd into the `experiment` directory. 

```bash
cd experiment
```

### Meta-World

To run the full AVDC on Meta-World, run the following command:

```bash
# make sure you have the checkpoint ../ckpts/metaworld/model-305.pt
bash benchmark_mw.sh 
```

### iTHOR

To run the full AVDC on iTHOR, run the following command:

```bash
# make sure you have the checkpoint ../ckpts/ithor/model-405.pt
bash benchmark_thor.sh 
```

## Acknowledgements

This codebase is modified from the following repositories:  
[avdc_exp](https://github.com/flow-diffusion/AVDC_experiments.git)  



