## scripts for reproducing the results

data pre-processing:
```
MAIN=tasks/graph_completion/main
DATA=tasks/graph_completion/datasets
. $MAIN/eval/collect_all_facts.sh $DATA/family
python $MAIN/eval/get_truths.py $DATA/family
. $MAIN/eval/collect_all_facts.sh $DATA/kinship_rnnlogic
python $MAIN/eval/get_truths.py $DATA/kinship_rnnlogic
. $MAIN/eval/collect_all_facts.sh $DATA/umls_rnnlogic
python $MAIN/eval/get_truths.py $DATA/umls_rnnlogic
. $MAIN/eval/collect_all_facts.sh $DATA/WN18RR
python $MAIN/eval/get_truths.py $DATA/WN18RR
. $MAIN/eval/collect_all_facts.sh $DATA/wn-18
python $MAIN/eval/get_truths.py $DATA/wn-18
```

running scripts:
```
TASK=family
TRIAL=${TASK}
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python tasks/graph_completion/main/src/main.py \
    --datadir tasks/graph_completion/datasets/$TASK \
    --model lerp --soft_logic naive-prob-matmul --max_epoch 30 \
    --headwise --learning_rate 1e-1 --width 40 --depth 2 --rank 10 --length 3 --init_var 0.1 --dense --headwise_batch_size 128 \
    --exps_dir=log --exp_name=$TRIAL --gpu --no_early_stop
python tasks/graph_completion/main/eval/evaluate.py \
    --preds=log/$TRIAL/test_predictions.txt \
    --truths=tasks/graph_completion/datasets/$TASK/truths.pckl
```

```
TASK=kinship_rnnlogic
TRIAL=${TASK}
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python tasks/graph_completion/main/src/main.py \
    --datadir tasks/graph_completion/datasets/$TASK \
    --model lerp --soft_logic naive-prob-matmul --max_epoch 30 \
    --headwise --learning_rate 1e-1 --width 400 --depth 2 --rank 100 --length 3 --init_var 0.1 --dense \
    --exps_dir=log --exp_name=$TRIAL --gpu --no_early_stop
python tasks/graph_completion/main/eval/evaluate.py \
    --preds=log/$TRIAL/test_predictions.txt \
    --truths=tasks/graph_completion/datasets/$TASK/truths.pckl
```

```
TASK=umls_rnnlogic
TRIAL=${TASK}
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python tasks/graph_completion/main/src/main.py \
    --datadir tasks/graph_completion/datasets/$TASK \
    --model lerp --soft_logic naive-prob-matmul --max_epoch 30 \
    --headwise --learning_rate 1e-1 --width 400 --depth 2 --rank 100 --length 3 --init_var 0.1 --dense \
    --exps_dir=log --exp_name=$TRIAL --gpu --no_early_stop
python tasks/graph_completion/main/eval/evaluate.py \
    --preds=log/$TRIAL/test_predictions.txt \
    --truths=tasks/graph_completion/datasets/$TASK/truths.pckl
```


```
TASK=WN18RR
TRIAL=${TASK}
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python tasks/graph_completion/main/src/main.py \
    --datadir tasks/graph_completion/datasets/$TASK \
    --model lerp --soft_logic naive-prob-matmul --max_epoch 10 \
    --headwise --learning_rate 1e-1 --width 10 --depth 2 --rank 4 --length 3 --init_var 0.1 --dense \
    --exps_dir=log --exp_name=$TRIAL --gpu --no_early_stop
python tasks/graph_completion/main/eval/evaluate.py \
    --preds=log/$TRIAL/test_predictions.txt \
    --truths=tasks/graph_completion/datasets/$TASK/truths.pckl
```


```
TASK=wn-18
TRIAL=${TASK}
CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python tasks/graph_completion/main/src/main.py \
    --datadir tasks/graph_completion/datasets/$TASK \
    --model lerp --soft_logic naive-prob-matmul --max_epoch 10 \
    --headwise --learning_rate 1e-1 --width 10 --depth 2 --rank 4 --length 3 --init_var 0.1 --dense \
    --exps_dir=log --exp_name=$TRIAL --gpu --no_early_stop
python tasks/graph_completion/main/eval/evaluate.py \
    --preds=log/$TRIAL/test_predictions.txt \
    --truths=tasks/graph_completion/datasets/$TASK/truths.pckl
```
