import io
import logging


def config_logfile(log_file):
    stream_handler = logging.StreamHandler()
    file_handler = logging.FileHandler(log_file)
    stream_handler.terminator = ""
    file_handler.terminator = ""
    logging.basicConfig(
        level=logging.INFO,
        format="%(message)s",
        handlers=[
            file_handler, stream_handler
        ],
    )


def log_and_print(*arg, **kwarg):
    stream = io.StringIO()
    print(*arg, **kwarg, file=stream)
    string = stream.getvalue()
    logging.info(string)
