function [X, Y, dX, dY, C] = multisol( mf, x0, varargin )

    parser = inputParser;
    parser.KeepUnmatched = true;
    addOptional(parser, 'outsize', 1);
    addParameter(parser,'NE', [0, 0]);
    addParameter(parser, 'NEeps', 1e-3);
    addParameter(parser, 'AutoReshape', 'off');
    addParameter(parser, 'Shape', 'square');
    parse(parser, varargin{:});
    
    args = parser.Results;
    
    n = args.outsize;
    m = size(x0, 2);
    
    X = zeros(n, m);
    Y = zeros(n, m);
    dX = zeros(n, m);
    dY = zeros(n, m);
    C = zeros(m, 1);

    for i = 1:size(x0, 2)
        
        [x, dx] = mf(x0(:, i));        
        
        % Determines the point of convergence among a set `eq` of
        % equilibrium points based on aminimum distance `eps`. If multiple
        % no equilibrium points or multiple equilibrium points satisfy this
        % condition then `C(i)` = 0.
        neidx = find(sqrt(sum((x(end, :) - args.NE) .^ 2, 2)) <= args.NEeps);
        if numel(neidx) ~= 1
            C(i) = 0;
        else
            C(i) = neidx(1);
        end        

        nx = x(1:n, :);
        X(:, i) = nx(:, 1);
        Y(:, i) = nx(:, 2);
        
        ndx = dx(1:n, :);
        dX(:, i) = ndx(:, 1);
        dY(:, i) = ndx(:, 2);

    end

    if strcmpi(args.AutoReshape, 'on')
        
        if strcmpi(args.Shape, 'square')
            sz = repelem(sqrt(m),1, 2);
        else
            sz = [args.Shape];
        end
    
        C = reshape(C, sz);
        
        sz = [n, sz];
        
        X = reshape(X, sz);
        Y = reshape(Y, sz);
        dX = reshape(dX, sz);
        dY = reshape(dY, sz);

    end
    
end