function mf = staghuntgdc( w, varargin )

    parser = inputParser;
    addParameter(parser,'dxThresh', 1e-4);
    parse(parser, varargin{:});
    
    args = parser.Results;

    u = staghuntpayoff(w); % The payoff matrix of the game.
    
    mf = @(x0) f(x0, u, args.dxThresh);
    
end

function dx = f(x, u, dxThresh)
    
    % Project `x(t)` in the simplex. Since `f` is non-smooth, `x(t)` may
    % fall outside the simplex. We approximate the correct value of `x(t)`
    % by projecting back in the simplex.
    x = max(0, min(x, 1)); % Note: Is there a preffered method to handle this problem?

    [px, py] = exppayoff([x(1, :); 1 - x(1, :)], [x(2, :); 1 - x(2, :)], u);
    
    dx = ((0 < x) .* (x < 1)) .* ([px(1, :) - px(2, :); py(1, :) - py(2, :)]) / 2;
    
    % Attempt to correct numerical errors in the computation of the
    % time-derivative by truncation.
    dx = dx .* any(abs(dx) > dxThresh);
    
end