function [Z, dZ] = tranpayoff (X, Y, u)
    
    szX = size(X);
    szY = size(Y);

    x = reshape(X, 1, []);
    y = reshape(Y, 1, []);
    [ux, uy] = exppayoff([x; 1 - x], [y; 1 - y], u);
    
    dZ{1} = reshape(ux(1, :) - ux(2, :), szY);
    dZ{2} = reshape(uy(1, :) - uy(2, :), szX);
    Z{1} = cumsum(dZ{1}, 1);
    Z{2} = cumsum(dZ{2}, 1);
    Z{1} = cat(1, zeros([1, szY(2:end)]), Z{1}(1:end - 1, :, :));
    Z{2} = cat(1, zeros([1, szX(2:end)]), Z{2}(1:end - 1, :, :));
    
end