%% Plot the APoA surface
[w,b] = meshgrid(1:0.2:1000,-400:0.2:1);

z = zeros(size(w));

for k = 1:length(w(1,:))
    v = w(1,k);
    for j = 1:length(b(:,1))
        c = b(j,1);
        if c >= 1-v
            z(j,k) = v.*(v+1-c).^2./( v.*(v+1-c).^2 - 2.*(1-c).^2.*(v-1));
        else 
            z(j,k) = v.*(v+1-c).^2./( (v+1-c).^2 + 2*v.^2*(v-1));
            z(j,k) = NaN; % to plot only the part that can be bounded
        end
    end
end

size(z);
fig1 = figure();
sc   = surfc(w,b,z);
tt = title({'\textbf{APoA in $\Gamma_{\beta, w}$}', 'for $\beta < 1-w$   '}, Interpreter='latex');
gg = get(tt,'Position');
set(tt, 'Position', gg - [0 0 0.49]);
gg = get(gca,'Position');
set(gca, 'Position', gg - [0.04 0 0 0]);

% Limits need to be set when plotting the bounded part and removed
% otherwise.
%zlim([1 2]);
%view([45 15]);
%view([0 90]);
colormap(batlow);
cbh = colorbar;
gg  = get(cbh, 'Position');
set(cbh, 'Position', [gg(1)+0.13 gg(2) gg(3)*0.5 gg(4)]);
%cbh.Limits = [1.0 2.0];
ylabel('$\beta$',Interpreter='latex');
xlabel('$w$',Interpreter='latex');
shading interp

%exportgraphics(fig1, 'fig_apoa_gbw_aop.png','BackgroundColor','white','Resolution','500')