%% Game: \Gamma_{b,w} or ID_{b,w}
w = 2;
b = 0;

% Fully mixed Nash Equilibrium (NE) strategies: x* = y* = w/w-1+b. Here eq1
% stands for (x*, 1-x*) and eq2 for (y*, 1-y*).

% For the symmetric games: A = [1 0; b w]; B = transpose(A).
eq1 = [w, 1-b]; 
eq1 = eq1/sum(eq1);
eq2 = eq1;

% For the identical interest games: A = [1 0; b w]; B = A.
eq1 = [w-b, 1]; 
eq1 = eq1/sum(eq1);
eq2 = [w, 1-b];
eq2 = eq2/sum(eq2);

%% Invariant functions and Plots (together in a for loop)

eps = 1e-12; % needed for plots
qs  = [0, 1-eps, 2-eps, 20];

fig1 = figure(Units="normalized", Position=[0 0.5 1 0.33]);
fig1 = tiledlayout(1,length(qs))

for i = 1:length(qs)
    q = qs(i);

% Invariant Function: c = value at separatrix (i.e., at the mixed NE).
    if q == 1
        c      = eq1(1)*log(eq1(1)) + eq1(2)*log(eq1(2)) - eq2(1)*log(eq2(1)) - eq2(2)*log(eq2(2))
        finv_q = @(x,y) eq1(1)*log(x) + eq1(2).*log(1-x) - eq2(1).*log(y) - eq2(2).*log(1-y) -c ;
        finv_q = @(x,y) - finv_q(x,y);
    elseif q == 2
        c      = log(eq1(1)) + log(eq1(2)) + eq1(1)/eq1(1) + eq1(2)/eq1(2) - log(eq2(1)) - log(eq2(2)) - eq2(1)/eq2(1) - eq2(2)/eq2(2);
        finv_q = @(x,y) log(x) + log(1-x) + eq1(1)./x + eq1(2)./(1-x) - log(y) - log(1-y) - eq2(1)/y - eq2(2)/(1-y) -c;
    else
        c      =  (2-q)^(-1)*(eq1(1).^(2-q) + eq1(2).^(2-q)) - ((2-q)*(q-1))^(-1)*((1-(2-q)*eq1(1).^(1-q))*eq1(1) + (1-(2-q)*eq1(2).^(1-q))*eq1(2)) ...
             - 1*((2-q)^(-1)*(eq2(1).^(2-q) + eq2(2).^(2-q)) - ((2-q)*(q-1))^(-1)*((1-(2-q)*eq2(1).^(1-q))*eq2(1) + (1-(2-q)*eq2(2).^(1-q))*eq2(2)));
        finv_q = @(x,y) (2-q)^(-1)*(x.^(2-q) + (1-x).^(2-q)) - (1-q)^(-1)*(eq1(1).*x^(1-q)+ eq1(2).*(1-x)^(1-q)) ...
               -     1*((2-q)^(-1)*(y.^(2-q) + (1-y).^(2-q)) - (1-q)^(-1)*(eq2(1).*y^(1-q)+ eq2(2).*(1-y)^(1-q))) - c;
    end    
    
    % Factor out the unstable manifold
    finv_q = @(x,y)  finv_q(x,y)/(y-x);

    % Required only to plot the whole surface. Not used here
    %z = arrayfun(finv_q,x,y);
    %z(z<-0.001) = NaN;
    %z(z>0.001) = NaN;
    %zm = max(z(~isinf(z)));
    
    nexttile
    hold all;
    fx = fimplicit(@(x,y) x-eq1(1), [0 1 0 1], '-.r', LineWidth = 0.5);
    fy = fimplicit(@(x,y) y-eq2(1), [0 1 0 1], '-.k', LineWidth = 0.5);
    ff = fimplicit(@(x,y) finv_q(x,y), [0 1 0 1], 'b', MeshDensity = 300, LineWidth = 1);
    fd = fimplicit(@(x,y) x-y, [0 1 0 1],'--b', LineWidth=0.5);
    hold on
    axis square
    shading interp;
    view([0,90]);
    tt  = title([' $q=$ ' num2str(q)],Interpreter="latex", FontSize=16);
    ptt = get(tt, 'Position');
    set(tt, 'Position', ptt+[0 -0.3 0])
    box on
    if q == qs(end)
        lgd = legend([{'$x^*$', '$y^*$', '$S_q(x,y)=0$', '$x=y$'}],'Interpreter','latex',Location='northeastoutside');
        ans = get(lgd, 'Position');
        set(lgd, 'Position', ans + [-0.02 -0.01 0 0]);
    end
end
    
% % For parametric naming of figures
% d = num2str(b);
% d(d=='.') = '';
% 
% qq = num2str(q);
% qq(qq=='.') = '';
% 
% exportgraphics(fig1,['fig_invariant_flat_app.png'],'BackgroundColor','white','Resolution','500')