function [x, dx] = mfode45( mf, x0, T )

    [~, x] = ode45(@(t, x) mf(x), [0, T], x0);
    
    % Project `x(t)` in the simplex, in case `mf` is inaccurate.
    x = max(0, min(x, 1)); % Note: Is there a preffered method to handle this problem?
    
    dx = mf(x')';
    
    % Truncate inaccesible points, created by unordered evaluations in the
    % exection of 'ode45'.
    thresidx = find(sum(abs(dx), 2) == 0, 1);
            
    for j = 1:size(dx, 2)
        x(thresidx + 1:end, j) = x(thresidx, j);
    end
    dx(thresidx + 1:end, :) = 0;

end