function p = plotscatter( X, Y, C, varargin)
    
    parser = inputParser;
    parser.KeepUnmatched = true;
    addParameter(parser,'cmap', defaultcmap());
    parse(parser, varargin{:});
    
    args = parser.Results;

    cmap = cat(1, zeros(1, 3), args.cmap); % Add 'black' as the default color for `C(i) = 0`.
    n = size(cmap, 1);
    p = cell(n, 1);
    
    % Plot multiple quiver plots with different colors from `cmap`.
    for pidx = 1:n
        
        idx = find(C == pidx - 1);
        if numel(idx) == 0
            continue;
        end
        
        p{pidx} = scatter(X(idx), Y(idx),3);
        
        color = cmap(pidx, :);
        set(p{pidx}, 'MarkerEdgeColor', color, 'MarkerFaceColor', color);
        
        axis square;
        hold on;

    end
    
    hold off;

end