function [pXY, ptZ, pdist, pbnd] = plotstaghuntpayoff( eta, X, Y, Z)

    cXY = [0.7412, 0.1922, 0.1922];
    ctZ = [0.2549, 0.4745, 0.8000];
    ccon = [0.2510, 0.4314, 0.1608];

    x = reshape(X(2:size(X, 1)), 1, []);
    y = reshape(Y(2:size(X, 1)), 1, []);
    tz{1} = reshape((eta * (Z{1}(2:size(Z{1}, 1))') + 1) / 2, 1, []);
    tz{2} = reshape((eta * (Z{2}(2:size(Z{2}, 1))') + 1) / 2, 1, []);
    
    pbnd = plot([0; 0; 1; 1; 0], [0; 1; 1; 0; 0], 'black', 'LineWidth', 2);
    hold on;
    
    pdist = plot([x; tz{1}], [y; tz{2}], 'black');
    hold on;
    
    pXY = plot(x', y, '--s', 'Color', ccon, 'LineWidth', 1.5, 'MarkerSize', 12, 'MarkerEdgeColor', cXY, 'MarkerFaceColor', cXY);
    hold on;
    
    ptZ = plot(tz{1}', tz{2}, 'o', 'MarkerSize', 6, 'MarkerEdgeColor', ctZ, 'MarkerFaceColor', ctZ); 
    hold off;
    
    xl = xlim;
    yl = ylim;
    
    xlim([min(0, xl(1)), max(1, xl(2))]);
    ylim([min(0, yl(1)), max(1, yl(2))]); 
    
    axis square;
    
end