function p = quivervf( X, Y, dX, dY, C, cork, varargin)

    parser = inputParser;
    parser.KeepUnmatched = true;
    addParameter(parser,'cmap', defaultcmap());
    addParameter(parser, 'AutoBounds', 'on');
    addParameter(parser, 'xlim', [0, 1]);
    addParameter(parser, 'ylim', [0, 1]);
    addParameter(parser, 'AutoScale', 'on');
    parse(parser, varargin{:});
    
    args = parser.Results;
    cork(50,:)
    cmap = cat(1, zeros(1, 3), args.cmap); % Add 'black' as the default color for `C(i) = 0`.
    cmap = [0 0 0; cork(40, :); cork(128, :); cork(225,:)];
    cmap = [0 0 0; [128 128 128]/255; cork(128, :); [1 0 0]];
    n = size(cmap, 1);
    p = cell(n, 1);
    
    % Plot multiple quiver plots with different colors from `cmap`.
    for pidx = 1:n
        
        idx = find(C == pidx - 1);
        if numel(idx) == 0
            continue;
        end
        
        p{pidx} = quiver(X(:, idx), Y(:, idx), dX(:, idx), dY(:, idx), 'AutoScale', args.AutoScale);
        set(p{pidx}, 'Color', cmap(pidx, :));
        
        axis square;
        
        if strcmpi(args.AutoBounds, 'off')
            xlim(args.xlim);
            ylim(args.ylim);
        end
        
        hold on;

    end
    
    hold off;
    
end