function mf = staghuntgd( w )

    u = staghuntpayoff(w);
      
    mf = @(x0, T, eta) f(x0, T, u, eta);

end

function [x, v] = f( x0, T, u, eta )

    x = zeros(T + 1, 2);
    p = zeros(2, 2);
    m = size(p, 2);
    
    x(1, :) = x0;
    
    for i = 1:T
        
        xi = x(i, 1)';
        yi = x(i, 2)';
        
        [pxi, pyi] = exppayoff([xi; 1 - xi], [yi; 1 - yi], u);
        p = p + [pxi, pyi]';

        for j = 1:2
            
            [spj, idxspj] = sort(p(j, :));
            
            accspj = sum(spj);
            cspj = size(spj, 2);
            
            for k = 1:m
                
                spjk = spj(k);
                prjk = prob(spjk, accspj, cspj, eta);
                
                if prjk >= 0
                    
                    idxk = idxspj(k);
                    
                    prj1 = prjk;
                    if idxk == m
                        prj1 = 1 - prj1;
                    end
                    
                    x(i + 1, j) = prj1;
                    
                    break
                    
                end
                
                accspj = accspj - spjk;
                cspj = cspj - 1;
            
            end
            
        end
        
    end
    
    v = x(2:T + 1, :) - x(1:T, :);
    x = x(1:T, :);
    
end

function prjk = prob( spjk, accspj, cspj, eta )

    prjk = (eta * (cspj * spjk - accspj) + 1) / cspj;    
    
end