%% Game: \Gamma_{b,w} or ID_{b,w}
w = 2;
b = 0;

% Fully mixed Nash Equilibrium (NE) strategies: x* = y* = w/w-1+b. Here eq1
% stands for (x*, 1-x*) and eq2 for (y*, 1-y*).

% For the symmetric games: A = [1 0; b w]; B = transpose(A).
eq1 = [w, 1-b]; 
eq1 = eq1/sum(eq1);
eq2 = eq1;

% For the identical interest games: A = [1 0; b w]; B = A.
eq1 = [w-b, 1]; 
eq1 = eq1/sum(eq1);
eq2 = [w, 1-b];
eq2 = eq2/sum(eq2);

%% Invariant function and Visualizations (together in a for loop)

eps = 1e-15; % needed for plots
qs  = [0, 1, 2, 20];

fig1  = figure(Units="normalized", Position=[0 0.5 1 0.33]);
tiledlayout(1,length(qs))
[x,y] = meshgrid(0:.01:1);

for i = 1:length(qs)
    q = qs(i);

% Invariant Function: c = value at separatrix (i.e., at the mixed NE)
% if q == 1
        c      = eq1(1)*log(eq1(1)) + eq1(2)*log(eq1(2)) - eq2(1)*log(eq2(1)) - eq2(2)*log(eq2(2))
        finv_q = @(x,y) eq1(1)*log(x) + eq1(2).*log(1-x) - eq2(1).*log(y) - eq2(2).*log(1-y) -c ;
        finv_q = @(x,y) - finv_q(x,y);
    elseif q == 2
        c      = log(eq1(1)) + log(eq1(2)) + eq1(1)/eq1(1) + eq1(2)/eq1(2) - log(eq2(1)) - log(eq2(2)) - eq2(1)/eq2(1) - eq2(2)/eq2(2);
        finv_q = @(x,y) log(x) + log(1-x) + eq1(1)./x + eq1(2)./(1-x) - log(y) - log(1-y) - eq2(1)/y - eq2(2)/(1-y) -c;
    else
        c      =  (2-q)^(-1)*(eq1(1).^(2-q) + eq1(2).^(2-q)) - ((2-q)*(q-1))^(-1)*((1-(2-q)*eq1(1).^(1-q))*eq1(1) + (1-(2-q)*eq1(2).^(1-q))*eq1(2)) ...
         - a*((2-q)^(-1)*(eq2(1).^(2-q) + eq2(2).^(2-q)) - ((2-q)*(q-1))^(-1)*((1-(2-q)*eq2(1).^(1-q))*eq2(1) + (1-(2-q)*eq2(2).^(1-q))*eq2(2)));
        finv_q = @(x,y) (2-q)^(-1)*(x.^(2-q) + (1-x).^(2-q)) - (1-q)^(-1)*(eq1(1).*x^(1-q)+ eq1(2).*(1-x)^(1-q)) ...
               - 1*((2-q)^(-1)*(y.^(2-q) + (1-y).^(2-q)) - (1-q)^(-1)*(eq2(1).*y^(1-q)+ eq2(2).*(1-y)^(1-q))) - c;
    end
    %finv_q = @(x,y) finv_q(x,y)/(y-x); %factor out (x-y)

    z = arrayfun(finv_q,x,y);
    %z(z<0) = NaN;

    nexttile
    hold all;
    pl  = plot(0,0,'LineStyle','none');
    sc  = surfc(x,y,z);
    %zm = max(z(~isinf(z)));
    %fimplicit3(@(x,y,z) x-eq1(1), [0 1 0 1 zm zm+eps], '-.r');
    %hold on
    %fimplicit3(@(x,y,z) y-eq2(1), [0 1 0 1 zm zm+eps], '-.r');
    axis tight
    shading interp;
    %sc(1).EdgeColor = '#666666';
    %view([0,90]);
    view([-40, 25]);
    lgd = legend([' $q=$ ' num2str(q)],'Interpreter','latex', 'Location','northwest', 'FontSize', 16);
    ans = get(lgd, 'Position'); %'Position',[0.2 0.6 0.1 0.2]
    set(lgd, 'Position', ans + [0.01 -0.01 0 0]);
    legend('boxoff')
    if q == qs(end)
        map = batlow;
        colormap(map);
        cbr = colorbar;
    end
end
    
% % For parametric naming of figures
% d = num2str(b);
% d(d=='.') = '';
% 
% qq = num2str(q);
% qq(qq=='.') = '';
% 
% exportgraphics(fig1,['fig_invariant_app.png'],'BackgroundColor','white','Resolution','500')