function p = plotvf( X, Y, dX, dY, C, cork, varargin )
    
    parser = inputParser;
    parser.KeepUnmatched = true;
    addParameter(parser, 'mode', 'quiver');
    parse(parser, varargin{:});
    
    args = parser.Results;
    
    switch args.mode
        
        case 'quiver'
            
            p = quivervf(X, Y, dX, dY, C, cork, parser.Unmatched);
             
        case 'streamslice'
            
            X0 = squeeze(X(1, :, :));
            Y0 = squeeze(Y(1, :, :));
            dX0 = squeeze(dX(1, :, :));
            dY0 = squeeze(dY(1, :, :));
            
            p = streamslicevf(X0, Y0, dX0, dY0, C, parser.Unmatched);
            
    end
    
end