function p = streamslicevf( X, Y, dX, dY, C, varargin )
    
    parser = inputParser;
    parser.KeepUnmatched = true;
    addParameter(parser,'cmap', defaultcmap()); 
    parse(parser, varargin{:});
    
    args = parser.Results;
    
    % Add 'black' as the default color for `C(i) = 0`, and remove unused
    % colors from `cmap` in order for `colormap` to correctly assign the
    % corresponding colors for each point in the `pc`.
    cmap = cat(1, zeros(1, 3), args.cmap);
    cmap = cmap(unique(C) + 1, :);
    
    pc = pcolor(X, Y, C);   
    colormap(map);
    shading flat;
    hold on;
    
    ss = streamslice(X, Y, dX, dY);
    set(ss, 'Color', 'black');
    hold off;
      
    axis square tight;
    
    p = {pc, ss};
    
end