%% Game: \Gamma_{b,w} or ID_{b,w}
w = 2;
b = 0;

% Fully mixed Nash Equilibrium (NE) strategies: x* = y* = w/w-1+b. Here eq1
% stands for (x*, 1-x*) and eq2 for (y*, 1-y*).

% For the symmetric games: A = [1 0; b w]; B = transpose(A).
eq1 = [w, 1-b]; 
eq1 = eq1/sum(eq1);
eq2 = eq1;

% For the identical interest games: A = [1 0; b w]; B = A.
eq1 = [w-b, 1]; 
eq1 = eq1/sum(eq1);
eq2 = [w, 1-b];
eq2 = eq2/sum(eq2);

%% Invariant functions

eps = 1e-12;

% Value of invariant functions at equilibrium
c  = @(q) (2-q).^(-1).*(eq1(1).^(2-q) + eq1(2).^(2-q)) - (1-q).^(-1).*(eq1(1).*eq1(1).^(1-q)+ eq1(2).*eq1(2).^(1-q)) ...
     - 1*((2-q).^(-1).*(eq2(1).^(2-q) + eq2(2).^(2-q)) - (1-q).^(-1).*(eq2(1).*eq2(1).^(1-q)+ eq2(2).*eq2(2).^(1-q)));% ...

% Plot the q = 0, q = 1 and q = 2 curves separately for clarity.
finv0  = @(x,y) 0.5.*(x.^2 + (1-x).^2) - eq1(1).*x - eq1(2).*(1-x) ...
              - 0.5.*(y.^2 + (1-y).^2) + eq2(1).*y + eq2(2).*(1-y) - c(0);% ...

q1 = 1 - eps; 
finv1  = @(x,y) (2-q1).^(-1).*(x.^(2-q1) + (1-x).^(2-q1)) - (1-q1).^(-1)*(eq1(1).*x.^(1-q1)+ eq1(2).*(1-x).^(1-q1)) ...
           - 1*((2-q1).^(-1).*(y.^(2-q1) + (1-y).^(2-q1)) - (1-q1).^(-1)*(eq2(1).*y.^(1-q1)+ eq2(2).*(1-y).^(1-q1)))-c(q1);

q2 = 2 - eps; 
finv2  = @(x,y) (2-q2).^(-1).*(x.^(2-q2) + (1-x).^(2-q2)) - (1-q2).^(-1)*(eq1(1).*x.^(1-q2)+ eq1(2).*(1-x).^(1-q2)) ...
           - 1*((2-q2).^(-1).*(y.^(2-q2) + (1-y).^(2-q2)) - (1-q2).^(-1)*(eq2(1).*y.^(1-q2)+ eq2(2).*(1-y).^(1-q2)))-c(q2);

% Parametric invariant for all q.
finv  = @(x,y,q) (2-q).^(-1).*(x.^(2-q) + (1-x).^(2-q)) - (1-q).^(-1).*(eq1(1).*x.^(1-q)+ eq1(2).*(1-x).^(1-q)) ...
            - 1*((2-q).^(-1).*(y.^(2-q) + (1-y).^(2-q)) - (1-q).^(-1).*(eq2(1).*y.^(1-q)+ eq2(2).*(1-y).^(1-q)))-c(q);% ...

%% Plots (in a for loop)
fig1 = figure(); 
set(groot,'defaultAxesTickLabelInterpreter','latex','defaulttextinterpreter','latex','defaultLegendInterpreter','latex');

ff = fimplicit3(finv, [0 1 0 1 0 10], MeshDensity = 501, LineWidth = 1);
ff(1).EdgeColor = 'none';
map = aux_crameri('cork', 'pivot', 3.5);
colormap(map);
shading interp;
grid on
view([0 90]);
gg = get(gca,'Position');
set(gca, 'Position', gg - [0.04 0 0 0]);
pbaspect([1 1 1]);

hold on
f0 = fimplicit(finv0,[0 1 0 1], 'Color', [0.8 0.8 0.8]/2, Linewidth = 1, MeshDensity=151);
hold on
f1 = fimplicit(finv1,[0 1 0 1], 'Color', [0.8 0.8 0.8]/3, Linewidth = 1, MeshDensity=151);
hold on
f2 = fimplicit(finv2,[0 1 0 1], 'Color', [0.8 0.8 0.8]/5, Linewidth = 1, MeshDensity=151);
hold on 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Text locations for 
% % beta = 0: 
% t0 = text(0.38,0.96,10,'$\leftarrow q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t1 = text(0.44,0.86,20,'$\longleftarrow q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t2 = text(0.02,0.88,20,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t3 = text(0.07,0.92,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);

% % beta = 0: 
% t0 = text(0.38,0.96,10,'$\leftarrow q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t1 = text(0.44,0.86,20,'$\longleftarrow q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t2 = text(0.02,0.88,20,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t3 = text(0.07,0.92,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);

% % beta = -10: 
% t2 = text(0.55,0.08,20,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t22 = text(0.5,0.04,20,'$\swarrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t1 = text(0.35,0.075,20,'$q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t11 = text(0.3,0.03,20,'$\swarrow$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t0 = text(0.16,0.08,20,'$q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t00 = text(0.11,0.03,20,'$\swarrow$','FontSize',12,'Color',[0.8 0.8 0.8]/3);

% % beta = -5: 
% t2 = text(0.1,0.93,10,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t22 = text(0.04,0.90,10,'$\swarrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t1 = text(0.3,0.07,20,'$q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t11 = text(0.35,0.11,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t0 = text(0.015,0.33,20,'$q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t00 = text(0.06,0.37,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/3);

% % beta = -2: 
% t0 = text(0.1,0.85,10,'$\leftarrow q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t1 = text(0.02,0.93,20,'$\longleftarrow q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t2 = text(0.02,0.62,20,'$q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t0 = text(0.07,0.66,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/3);

% beta = -1: 
%t0 = text(0.16,0.85,10,'$\leftarrow q=0,1,2$ (coincide for all $q$)','FontSize',12,'Color',[0.8 0.8 0.8]/3);
%t1 = text(0.44,0.86,20,'$\longleftarrow q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
%t2 = text(0.02,0.88,20,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
%t3 = text(0.07,0.92,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);

% % beta = -0.5: 
% t0 = text(0.185,0.96,10,'$\leftarrow q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t1 = text(0.22,0.88,20,'$\longleftarrow q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t2 = text(0.02,0.853,20,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t3 = text(0.07,0.893,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);

% % beta = 0.6: 
% t0 = text(0.695,0.975,10,'$\leftarrow q=0$','FontSize',12,'Color',[0.8 0.8 0.8]/3);
% t1 = text(0.72,0.92,20,'$\longleftarrow q=1$','FontSize',12,'Color',[0.8 0.8 0.8]/4);
% t2 = text(0.02,0.91,20,'$q=2$','FontSize',12,'Color',[0.8 0.8 0.8]/5);
% t3 = text(0.07,0.95,20,'$\nearrow$','FontSize',12,'Color',[0.8 0.8 0.8]/5);

c = colorbar;
ylabel(c,'\textbf{$q$}','Interpreter','latex','Rotation', 360, 'FontSize',13);
title(c,'\textbf{$q$-Replicator}',Interpreter ='latex');
gg = get(c, 'Position');
ylabel('$y$','Interpreter','latex','Rotation', 360, 'FontSize',13);
xlabel('$x$','Interpreter','latex', 'FontSize',13);
set(c, 'Position', [gg(1)+0.13 gg(2) gg(3)*0.5 gg(4)]);

x1 = [0.46 0.4];
y1 = [0.85 0.8];
st1 = annotation('textarrow',x1,y1,'String','Stable manifolds');
st1.Color = [0 0.4470 0.7410];
x2 = [0.54 0.54];
y2 = [0.85 0.72];
st2 = annotation('arrow',x2,y2);%'String','Stable manifolds')
st2.Color = [0 0.4470 0.7410];
x3 = [0.63 0.74];
y3 = [0.85 0.34];
st3 = annotation('arrow',x3,y3);%,'String','Stable manifolds')
st3.Color = [0 0.4470 0.7410];

x1 = [0.3 0.3];
y1 = [0.37 0.27];
un1 = annotation('textarrow',x1,y1,'String','Unstable manifolds');
un1.Color = 'red';
x2 = [0.41 0.61];
y2 = [0.387 0.387];
un2 = annotation('arrow',x2,y2);%'String','Stable manifolds')
un2.Color = 'red';
x3 = [0.41 0.7];
y3 = [0.41 0.77];
un3 = annotation('arrow',x3,y3);%,'String','Stable manifolds')
un3.Color = 'red';

t3 = text(0.69,0.4,20,'mixed NE','FontSize',10);

x0 = [0.5 0.435];
y0 = [0.13 0.13];
t0 = annotation('textarrow',x0,y0,'String',' $\;\;q=0$', Interpreter='latex');
t0.Color = [0.8 0.8 0.8]/2;

x1 = [0.52 0.43];
y1 = [0.19 0.19];
t1 = annotation('textarrow',x1,y1,'String','$\;\;q=1$', Interpreter='latex');
t1.Color = [0.8 0.8 0.8]/3;

x2 = [0.56 0.47];
y2 = [0.25 0.25];
t2 = annotation('textarrow',x2,y2,'String',' $\;\;q=2$', Interpreter='latex');
t2.Color = [0.8 0.8 0.8]/5;

%tt =title({'\textbf{Stable manifold in $\Gamma_{2,\beta}$}', ['\textbf{for} $q\in[0,10]$, $\beta= $ ' num2str(b)]}, Interpreter='latex');
%gg = get(tt,'Position');
%%%%%%%%%%%%%%%%%% Title position for a > 0.5.
% set(tt, 'Position', gg - [0.16 0.808 0]);
%%%%%%%%%%%%%%%%%% Title position for a < 0.5.
%set(tt, 'Position', gg + [0.16 -0.308 0]);

bb = replace(num2str(b), '.','');
%exportgraphics(fig1,'fig_separatrix_app_equal.png','BackgroundColor','white','Resolution','500');