# R2-Dreamer: Redundancy-Reduced World Models without Decoders or Augmentation

This is the official implementation of the paper "R2-Dreamer: Redundancy-Reduced World Models without Decoders or Augmentation".

## Setup

This code is tested with Python 3.11 with Ubuntu20.04. Install the dependencies with:
```bash
pip install -r requirements.txt
```

## Usage

#### Training

To train the model on a specific task, run the following command. The training logs and model checkpoints will be saved to the directory specified by `--logdir`.

**Example:** Train R2-Dreamer on the `dmc_walker_walk` task.
```bash
python3 train.py env.task=dmc_walker_walk device=cuda:0 model.rep_loss=r2dreamer seed=0 logdir=./logdir/test_walker_walk
```

You can switch the algorithm by changing the `model.rep_loss` argument as follows:

| Algorithm         | `model.rep_loss` option |
| ----------------- | ----------------------- |
| R2-Dreamer        | `r2dreamer`             |
| Dreamer           | `dreamer`               |
| Dreamer-InfoNCE   | `infonce`               |
| DreamerPro        | `dreamerpro`            |

#### Monitoring

You can monitor the training progress using TensorBoard:
```bash
tensorboard --logdir ./logdir
```
This will launch a web server where you can view training curves, such as rewards and model losses.

#### Reproducing Results

To reproduce the results reported in the paper, run the corresponding script:
- For DMC tasks, execute `run_dmc.sh`.
- For DMC-Subtle tasks, execute `run_DMC-Subtle.sh`.

To change the algorithm, modify the `METHOD` variable at the top of the respective shell script (e.g., `METHOD=r2dreamer`). The available options for `METHOD` are listed in the table above.
