#!/bin/bash

# ==== METHOD ====
METHOD=r2dreamer
# ==== Date and Seed ====
DATE=$(date +%m%d) # auto complete
SEED_START=0
SEED_END=400
SEED_STEP=100

# ==== Tasks ====
tasks=(
    dmc_ball_in_cup_catch_subtle
    dmc_cartpole_swingup_subtle
    dmc_finger_turn_subtle
    dmc_point_mass_subtle
    dmc_reacher_subtle
)

# ==== Loop ====
for task in "${tasks[@]}"
do
    for seed in $(seq $SEED_START $SEED_STEP $SEED_END)
    do
        python3 train.py \
            env.task=$task \
            model.rep_loss=${METHOD} \
            logdir=logdir/${DATE}_${METHOD}_${task#dmc_}_$seed
    done
done
