import sys
from torch.utils.tensorboard.writer import SummaryWriter
from continual_rl.utils.argparse_manager import ArgparseManager
import torch.multiprocessing as multiprocessing


def run_next_experiment():
    experiment, policy, keep_parsing = ArgparseManager.parse(sys.argv[1:])

    if experiment is not None:
        summary_writer = SummaryWriter(log_dir=experiment.output_dir)
        experiment.try_run(policy, summary_writer=summary_writer)
    else:
        keep_parsing = False

    return keep_parsing


if __name__ == "__main__":
    # Needs to run once, not totally sure of the best place
    multiprocessing.set_start_method('spawn')
    keep_parsing = True

    while keep_parsing:
        keep_parsing = run_next_experiment()

    print("No more experiments")
