# Effect of Pruning on Adversarial Robustness


This is the implementation of our paper "When Less Is More: Uncovering the Robustness Advantage of Model Pruning" currently under review at ICLR. We theoretically study the effect of pruning on the adversarial robustness of the underlying model. We show typically that these two quantities are linked and there exists a certain trade-off between the two of them.

## Code
The code is based on PyTorch mainly and requires having access to TorchVision for the loaders. We use public datasets that can directly be downloaded while running the script.

## Usage
To reproduce the results of the first part where we understanding the trade-off between clean and attacked accuracy when subject to different pruning values. Note that you can define your own parameters, but to run with the default used ones for MNIST dataset:
```python
python mlp_attack.py --dataset mnist
```

And to run for CIFAR-10
```python
python mlp_attack.py --dataset cifar10
```


Finally to run the experiment that considers different sizes of the MLP on the MNIST dataset you can directly use the following command:
```python
python multiple_size.py --dataset cifar10
```

---

For any additional information, please refer to our paper.
