from denoising_diffusion_pytorch import Unet, GaussianDiffusion, Trainer

def main():

    # Define the U-Net model for diffusion
    model = Unet(
        dim=128,
        channels=3,
        dim_mults=(1, 2, 4, 8)
    )

    # Define the Gaussian Diffusion process
    diffusion = GaussianDiffusion(
        model,
        image_size=128,
        timesteps=1000,
        auto_normalize=False,
    )

    # Set up the Trainer to handle training
    trainer = Trainer(
        diffusion,
        '', # Butterfly images folder
        train_batch_size=8,
        train_lr=5e-5,          # Learning rate
        train_num_steps=20000,  # Total training steps
        num_samples=9,        # Number of samples to generate
        gradient_accumulate_every=2,  # Gradient accumulation steps
        ema_decay=0.995,         # Exponential moving average decay for model weights
        amp=False,               # Disable automatic mixed precision training
        calculate_fid=False,     # Disable FID calculation
        augment_horizontal_flip=False # Disable horizontal flip augmentation
    )

    # Start training
    trainer.train()

if __name__ == '__main__':
    main()