# Collaborative Threshold Watermarking

## Installation

```bash
conda create -n ctwm python=3.8
conda activate ctwm
pip install torch torchvision scipy matplotlib seaborn pandas numpy
pip install -e .
```

## Running the Code

### Baseline Experiments
```bash
conda run -n ctwm python example/baseline_resnet18.py
conda run -n ctwm python example/baseline_resnet18_cifar100.py
conda run -n ctwm python example/baseline_tinyimagenet.py
```

### Trusted Server
```bash
conda run -n ctwm python example/trusted_server_resnet18.py
conda run -n ctwm python example/trusted_server_resnet18_cifar100.py
conda run -n ctwm python example/trusted_server_tinyimagenet.py
```

### Untrusted Server
```bash
conda run -n ctwm python example/untrusted_server_resnet18.py
conda run -n ctwm python example/untrusted_server_resnet18_cifar100.py
conda run -n ctwm python example/untrusted_server_tinyimagenet.py
```

### Attack Scripts

#### Finetuning Attacks
```bash
python src/finetuning_attack_cifar_10.py
python src/finetuning_attack_cifar_100.py
python src/finetuning_attack_tiny.py
```

#### Distillation Attacks
```bash
python src/distillation_attack_cifar_10.py
python src/distillation_attack_cifar_100.py
python src/distillation_attack_tiny.py
```

#### Pruning Attacks
```bash
python src/pruning_attack_cifar_10.py
python src/pruning_attack_cifar_100.py
python src/pruning_attack_tiny.py
```

#### Quantization Attacks
```bash
python src/quantization_attack_cifar_10.py
python src/quantization_attack_cifar_100.py
python src/quantization_attack_tiny.py
```

### Statistical Analysis
```bash
conda run -n ctwm python calculate_mean_std.py
```

## File Structure
```
src/
├── ResNet.py                       # ResNet18 for CIFAR
├── ResNetTinyImageNet.py          # ResNet18 for TinyImageNet
├── data_utils.py                  # Dataset loaders
├── utils.py                       # Utility functions
├── Client.py                      # Base client
├── ClientResNet18.py              # CIFAR client
├── ClientResNetTinyImageNet.py    # TinyImageNet client
├── *_attack_*.py                  # Attack implementations

example/
├── baseline_*.py                  # Baseline experiments
├── trusted_server_*.py            # Trusted server scenarios
├── untrusted_server_*.py          # Untrusted server scenarios
└── generate_individual_plots.py   # Plot generation
```
