from experiments.target_lnpdfs.LogisticRegression import *
from experiments.VIPS.experiment_script import learn, construct_initial_mixture
import os
import numpy as np
from optimization.VIPS import MoreVIPS
import time

my_directory = os.path.dirname(os.path.abspath(__file__))

def run_experiment(path, algorithm, experiment, add_iters, reused_samples, desired_samples):
    os.environ["CUDA_VISIBLE_DEVICES"] = "-1"
    if experiment == "breastCancer":
        dataset = make_breast_cancer
        model = construct_initial_mixture(31, 1, 10)
        groundtruth = np.load(os.path.join(my_directory, "../target_lnpdfs/tests/breastcancer_gt_with_lns_10k.npz"))['groundtruth']
    elif experiment == "GermanCredit":
        dataset = make_german_credit
        model = construct_initial_mixture(25, 1, 10)
        groundtruth = np.load(os.path.join(my_directory,"../target_lnpdfs/tests/german_credit10k.npy"))
    else:
        print("unknown experiment")
        return

    config = MoreVIPS.get_default_config()
    config.component_optimizer = algorithm
    config.reused_samples_per_component = reused_samples
    config.desired_samples_per_component = desired_samples
    config.add_iters = add_iters
    config.mmd_alpha = 20
    config.mmd_rate = 100
    learn(target_dist_maker=dataset, path=path,
          groundtruth=groundtruth, model=model, config=config, do_plots=True)

if __name__ == "__main__":
    run_experiment(os.path.join(my_directory,"../../data/logistic_regression/", str(time.time())), "gradientMORE", "breastCancer", add_iters=30, reused_samples=300, desired_samples=100)