import os
os.environ["CUDA_VISIBLE_DEVICES"] = "-1"
from experiments.target_lnpdfs.GMM import make_target
from experiments.VIPS.experiment_script import learn, construct_initial_mixture
import numpy as np
from optimization.VIPS import MoreVIPS
from pathlib import Path
import time

my_directory = os.path.dirname(os.path.abspath(__file__))

def run_experiment(path, algorithm, num_initial_samples, num_dimensions, add_iters, reused_samples, desired_samples):
    os.environ["CUDA_VISIBLE_DEVICES"] = "-1"
    target_fn = lambda: make_target(num_dimensions)
    model = construct_initial_mixture(num_dimensions=num_dimensions, num_initial_components=1, prior_scale=np.sqrt(1000))

    config = MoreVIPS.get_default_config()
    config.component_optimizer = algorithm
    config.reused_samples_per_component = reused_samples
    config.desired_samples_per_component = desired_samples
    config.num_initial_samples = num_initial_samples
    config.add_iters = add_iters
    Path(path).mkdir(parents=True, exist_ok=True)

    learn(target_dist_maker=target_fn, path=path,
          groundtruth=[], model=model, config=config, do_plots=True)

if __name__ == "__main__":
    run_experiment(os.path.join(my_directory,"../../data/target_GMM/", str(time.time())), "gradientMORE", 50000, 20, 30, 400, 200)

