from experiments.target_lnpdfs.Planar_Robot import make_four_goal, make_single_goal
from experiments.VIPS.experiment_script import learn, construct_initial_mixture
import os
import numpy as np
from optimization.VIPS import MoreVIPS
import time

my_directory = os.path.dirname(os.path.abspath(__file__))

def run_experiment(path, algorithm, experiment, add_iters, reused_samples, desired_samples):
    os.environ["CUDA_VISIBLE_DEVICES"] = "-1"
    num_dimensions = 10
    conf_likelihood_var = 4e-2 * np.ones(num_dimensions)
    conf_likelihood_var[0] = 1

    if experiment == "four_goal":
        target_fn = make_four_goal
        model = construct_initial_mixture(num_dimensions=num_dimensions, num_initial_components=100, prior_scale=np.sqrt(conf_likelihood_var))
        gt_samples = np.load(os.path.join(my_directory, "../target_lnpdfs/tests/planar10_4p_10kOf20M_samples.npy")) # wrong sample set
    else:
        target_fn = make_single_goal
        gt_samples = np.load(os.path.join(my_directory, "experiments/target_lnpdfs/tests/icml_10link_samples_10kof25.6mio.npz"))['arr_0']
        model = construct_initial_mixture(num_dimensions=num_dimensions, num_initial_components=100, prior_scale=np.sqrt(conf_likelihood_var))

    config = MoreVIPS.get_default_config()
    config.component_optimizer = algorithm
    config.reused_samples_per_component = reused_samples
    config.desired_samples_per_component = desired_samples
    config.add_iters = add_iters
    config.mmd_alpha = 20
    config.mmd_rate = 100
    learn(target_dist_maker=target_fn, path=path,
          groundtruth=gt_samples, model=model, config=config, do_plots=True)

    print("done")

if __name__ == "__main__":
    run_experiment(os.path.join(my_directory,"../../data/planar_robot/", str(time.time())),
                   "gradientMORE", "four_goal", add_iters=30, reused_samples=300, desired_samples=150)