import argparse
import time

parser = argparse.ArgumentParser(description='Process some integers.')
parser.add_argument('--Experiment', action="append", type=str,
                    help='Either breastCancer, GermanCredit, Planar1, Planar4, GMM20, GMM40, GMM60, GMM80 or GMM100')
parser.add_argument('--Algorithm',  action="append", type=str,
                    help='Either MORE, gMORE, gMORE_NFO, VON, VOGN, or GM.')
parser.add_argument('--path', action="append", type=str,
                    help='path were data should be stored')
parser.add_argument('--add_rate', type=float, help='A new component will be added every X iterations')
parser.add_argument('--n_reused', type=int, help='number of reused samples')
parser.add_argument('--n_desired', type=int, help='number of desired samples')

args = parser.parse_args()

def get_reused(experiment, algorithm):
    if experiment == "breastCancer":
        if algorithm == "gMORE":
            return 200
        if algorithm == "VON":
            return 20
        if algorithm == "VOGN":
            return 5
        if algorithm == "GM":
            return 100
    if experiment == "GermanCredit":
        if algorithm == "gMORE":
            return 100
        if algorithm == "VON":
            return 5
        if algorithm == "VOGN":
            return 5
        if algorithm == "GM":
            return 100
    if experiment == "Planar1":
        if algorithm == "gMORE":
            return 100
        if algorithm == "VON":
            return 5
        if algorithm == "VOGN":
            return 5
        if algorithm == "GM":
            return 100
    if experiment == "Planar4":
        if algorithm == "gMORE":
            return 100
        if algorithm == "VON":
            return 5
        if algorithm == "VOGN":
            return 5
        if algorithm == "GM":
            return 100
    if experiment.startswith("GMM"):
        if algorithm == "gMORE":
            return int(int(experiment[3:]) * 5)
        if algorithm == "VON":
            return 100
        if algorithm == "VOGN":
            return 100
        if algorithm == "GM":
            return 100
    else:
        raise Exception("Invalid Experiment name "+experiment)

def get_desired(experiment, algorithm):
    if experiment == "breastCancer":
        if algorithm == "gMORE":
            return 100
        if algorithm == "VON":
            return 10
        if algorithm == "VOGN":
            return 3
        if algorithm == "GM":
            return 50
    if experiment == "GermanCredit":
        if algorithm == "gMORE":
            return 50
        if algorithm == "VON":
            return 3
        if algorithm == "VOGN":
            return 3
        if algorithm == "GM":
            return 50
    if experiment == "Planar1":
        if algorithm == "gMORE":
            return 50
        if algorithm == "VON":
            return 3
        if algorithm == "VOGN":
            return 5
        if algorithm == "GM":
            return 50
    if experiment == "Planar4":
        if algorithm == "gMORE":
            return 50
        if algorithm == "VON":
            return 3
        if algorithm == "VOGN":
            return 5
        if algorithm == "GM":
            return 50
    if experiment.startswith("GMM"):
        if algorithm == "gMORE":
            return int(int(experiment[3:]) * 2.5)
        if algorithm == "VON":
            return 50
        if algorithm == "VOGN":
            return 50
        if algorithm == "GM":
            return 50
    else:
        raise Exception("Invalid Experiment name "+experiment)

def fill_defaults(args):
    if args.Experiment == None:
        exp = "breastCancer"
    else:
        exp = args.Experiment[0]
    if args.Algorithm == None:
        algorithm = "gMORE"
    else:
        algorithm = args.Algorithm[0]
    if args.add_rate == None:
        add_rate = 30
    else:
        add_rate = 0
    if args.n_reused == None:
        n_reused = get_reused(exp, algorithm)
    else:
        n_reused = args.n_reused
    if args.n_desired == None:
        n_desired = get_desired(exp, algorithm)
    else:
        n_desired = args.n_desired
    if args.path is None:
        path = "data/"+str(time.time())
    else:
        path = args.path
    return exp, algorithm, add_rate, n_reused, n_desired, path

if __name__ == "__main__":
    experiment, algorithm, add_rate, n_reused, n_desired, path = fill_defaults(args)
    if experiment == "breastCancer" or experiment == "GermanCredit":
        from experiments.VIPS.logistic_regression import run_experiment
        run_experiment(path, algorithm, experiment, add_rate, n_reused, n_desired)
    if experiment == "Planar1":
        from experiments.VIPS.planar_robot import run_experiment
        run_experiment(path, algorithm, "one_goal", add_rate, n_reused, n_desired)
    if experiment == "Planar4":
        from experiments.VIPS.planar_robot import run_experiment
        run_experiment(path, algorithm, "four_goal", add_rate, n_reused, n_desired)
    if experiment.startswith("GMM"):
        from experiments.VIPS.target_gmm import run_experiment
        dimensions = int(experiment[3:])
        run_experiment(path, algorithm, 0, dimensions, add_rate, n_reused, n_desired)


