import tensorflow as tf

@tf.function(input_signature=[tf.TensorSpec(shape=[None, None], dtype=tf.float32),
                              tf.TensorSpec(shape=[None], dtype=tf.float32)])
def get_effective_samples(model_densities, oldsamples_pdf):
    log_weight = model_densities - tf.expand_dims(oldsamples_pdf, axis=0)
    log_weight = log_weight - tf.reduce_logsumexp(log_weight, axis=1, keepdims=True)
    weights = tf.exp(log_weight)
    num_effective_samples = 1. / tf.reduce_sum(weights * weights, axis=1)
    return num_effective_samples