# TEST_RESULT: True

from functools import cmp_to_key

def asc_desc_ending_comparator(a, b):
    for i in range(len(a)):
        if (i + 1) % 2 != 0:
            if a[i] < b[i]:
                return -1
            elif a[i] > b[i]:
                return 1
        elif a[i] > b[i]:
            return -1
        elif a[i] < b[i]:
            return 1
    return 0

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, m) = map(int, lines[0].split())
    books = [(title, idx) for (idx, title) in enumerate(lines[1:], start=1)]
    books.sort(key=cmp_to_key(lambda x, y: asc_desc_ending_comparator(x[0], y[0])))
    output = [str(book[1]) for book in books]
    return ' '.join(output)
