# TEST_RESULT: True
from typing import List, Tuple


def dfs(u: int, v: int, prev_color: int, switches: int, k: int, graph: List[List[Tuple[int, int]]], happiness: List[int], visited: List[bool]) -> Tuple[int, bool]:
    if switches > k:
        return (0, False)
    if u == v:
        return (happiness[u - 1], True)
    visited[u] = True
    total_happiness = 0
    found = False
    for (neighbor, color) in graph[u]:
        if visited[neighbor]:
            continue
        if prev_color != -1 and prev_color != color:
            new_switches = switches + 1
        else:
            new_switches = switches
        (hap, is_found) = dfs(neighbor, v, color, new_switches, k, graph, happiness, visited)
        if is_found:
            total_happiness += hap + happiness[u - 1]
            found = True
            break
    visited[u] = False
    return (total_happiness, found)

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, k) = map(int, lines[0].split())
    happiness = list(map(int, lines[1].split()))
    edges = [list(map(int, line.split())) for line in lines[2:]]
    graph = [[] for _ in range(n + 1)]
    for (u, v, t) in edges:
        graph[u].append((v, t))
        graph[v].append((u, t))
    total_happiness = 0
    visited = [False] * (n + 1)
    for u in range(1, n + 1):
        for v in range(u, n + 1):
            (hap, _) = dfs(u, v, -1, 0, k, graph, happiness, visited)
            total_happiness += hap
    return str(total_happiness % (10**9+7))
