import random


def gen_input(n_max, m_max, k_max):
    n = random.randint(1, n_max)
    m = random.randint(1, m_max)
    k = random.randint(1, min(k_max, m))
    grid = []
    for i in range(n):
        row = []
        for j in range(m):
            if j == 0:
                row.append(random.choice([1, 2]))
            elif j == m - 1:
                row.append(random.choice([2, 3]))
            else:
                row.append(random.randint(1, 3))
        grid.append(row)
    columns = [random.randint(1, m) for _ in range(k)]
    inputs = f'{n} {m} {k}\n'
    inputs += '\n'.join((' '.join((str(a) for a in row)) for row in grid)) + '\n'
    inputs += ' '.join((str(c) for c in columns))
    return inputs

def batch_gen_inputs(batch_size,):
    inputs = [gen_input(5, 5, 5) for _ in range(batch_size)]
    return inputs
