# TEST_RESULT: True
from collections import deque
from typing import List

def count_inversions(arr: List[int]) -> int:
    """Count the number of inversions in an array."""
    inversions = 0
    for i in range(len(arr)):
        for j in range(i + 1, len(arr)):
            if arr[i] > arr[j]:
                inversions += 1
    return inversions

def min_inversions_dfs(arr: List[int], dq: deque) -> int:
    """Find the minimum number of inversions using DFS."""
    if not arr:
        return count_inversions(list(dq))
    next_elem = arr.pop(0)
    dq.appendleft(next_elem)
    inversions_beginning = min_inversions_dfs(arr.copy(), dq.copy())
    dq.popleft()
    dq.append(next_elem)
    inversions_end = min_inversions_dfs(arr.copy(), dq.copy())
    dq.pop()
    return min(inversions_beginning, inversions_end)

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    test_cases = []
    for i in range(1, len(lines), 2):
        n = int(lines[i])
        arr = list(map(int, lines[i + 1].split()))
        test_cases.append(arr)
    output = []
    for arr in test_cases:
        dq = deque()
        min_inversions = min_inversions_dfs(arr.copy(), dq)
        output.append(str(min_inversions))
    return '\n'.join(output)
