# TEST_RESULT: True
from itertools import product

def count_valid_plans(n, m, plans):
    count = 0
    for plan in plans:
        is_valid = True
        for i in range(n - 1):
            if plan[i] + plan[i + 1] >= m:
                is_valid = False
                break
        if plan[0] + plan[-1] >= m:
            is_valid = False
        if is_valid:
            count += 1
    return count

def solution(stdin: str) -> str:
    (n, m) = map(int, stdin.strip().split())
    difficulties = list(range(m))
    all_plans = product(difficulties, repeat=n)
    num_plans = count_valid_plans(n, m, all_plans)
    return str(num_plans % 998244353)
