import random

def gen_input(num_cases: int, max_len: int, max_val: int) -> str:
    test_cases = []
    for _ in range(num_cases):
        n = random.randint(2, max_len)
        a = [random.randint(-max_val, max_val) for _ in range(n)]
        a = [i if i != 0 else i + 1 for i in a]
        test_cases.append((n, a))
    input_str = str(num_cases) + '\n'
    for (n, a) in test_cases:
        input_str += str(n) + '\n'
        input_str += ' '.join(map(str, a)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(num_cases=2, max_len=5, max_val=10))
    return inputs
