# TEST_RESULT: True
from typing import List


def is_composite(num: int) -> bool:
    if num <= 3:
        return False
    for i in range(2, int(num ** 0.5) + 1):
        if num % i == 0:
            return True
    return False

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = []
    index = 1
    for _ in range(t):
        n = int(lines[index])
        array = list(map(int, lines[index + 1].split()))
        index += 2
        max_subset_size = 0
        max_subset_indices = []
        for i in range(2 ** n):
            binary_str = bin(i)[2:].zfill(n)
            subset_indices = [j + 1 for j in range(n) if binary_str[j] == '1']
            subset = [array[j] for j in range(n) if binary_str[j] == '1']
            if is_composite(sum(subset)):
                if len(subset) > max_subset_size:
                    max_subset_size = len(subset)
                    max_subset_indices = subset_indices
        output.append(str(max_subset_size))
        output.append(' '.join(map(str, max_subset_indices)))
    return '\n'.join(output)
