import random


def gen_input(n: int, m: int, q: int, seed: int=0) -> str:
    random.seed(seed)
    edges = [[i, i + 1] for i in range(1, n)]
    for _ in range(m - n + 1):
        x = random.randint(1, n)
        y = random.randint(1, n)
        while x == y or [x, y] in edges or [y, x] in edges:
            x = random.randint(1, n)
            y = random.randint(1, n)
        edges.append([x, y])
    queries = []
    for _ in range(q):
        a = random.randint(1, n)
        b = random.randint(1, n)
        while a == b:
            a = random.randint(1, n)
            b = random.randint(1, n)
        queries.append([a, b])
    output = f'{n} {m}\n'
    for edge in edges:
        output += f'{edge[0]} {edge[1]}\n'
    output += f'{q}\n'
    for query in queries:
        output += f'{query[0]} {query[1]}\n'
    return output

def batch_gen_inputs(batch_size,) -> list[str]:
    inputs = []
    for seed in range(batch_size):
        n = random.randint(2, 10)
        m = random.randint(n - 1, min(n * (n - 1) // 2, 30))
        q = random.randint(1, min(n, 30))
        inputs.append(gen_input(n, m, q, seed))
    return inputs
