import random


def gen_input(n_upper_bound):
    n = random.randint(1, n_upper_bound)
    times = random.sample(range(1, 2 * n + 1), 2 * n)
    tasks = [(min(times[i], times[i + 1]), max(times[i], times[i + 1])) for i in range(0, 2 * n, 2)]
    t = random.randint(1, n)
    s = random.sample(range(1, n + 1), t)
    input_str = str(n) + '\n'
    for (a, b) in tasks:
        input_str += f'{a} {b}\n'
    input_str += str(t) + '\n'
    input_str += ' '.join(map(str, s)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    return [gen_input(5) for _ in range(batch_size)]
